/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.helpers;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.namespace.QName;
import jlibs.core.lang.Util;
import jlibs.core.net.URLUtil;
import jlibs.xml.Namespaces;
import org.xml.sax.helpers.NamespaceSupport;

public class MyNamespaceSupport
extends NamespaceSupport {
    private Properties suggested;
    private boolean needNewContext;

    public MyNamespaceSupport() {
        this(Namespaces.getSuggested());
    }

    public MyNamespaceSupport(Properties suggested) {
        this.suggested = suggested;
    }

    public void suggestPrefix(String prefix, String uri) {
        this.suggested.put(prefix, uri);
    }

    public String findPrefix(String uri) {
        String prefix;
        if (uri == null) {
            uri = "";
        }
        if ((prefix = this.getPrefix(uri)) == null) {
            String defaultURI = this.getURI("");
            if (defaultURI == null) {
                defaultURI = "";
            }
            if (Util.equals((Object)uri, (Object)defaultURI)) {
                prefix = "";
            }
        }
        return prefix;
    }

    public String declarePrefix(String uri) {
        String prefix = this.findPrefix(uri);
        if (prefix == null) {
            prefix = URLUtil.suggestPrefix((Properties)this.suggested, (String)uri);
            if (this.getURI(prefix) != null) {
                int i = 1;
                while (true) {
                    String _prefix;
                    if (this.getURI(_prefix = prefix + i) == null) {
                        prefix = _prefix;
                        break;
                    }
                    ++i;
                }
            }
            this.declarePrefix(prefix, uri);
        }
        return prefix;
    }

    @Override
    public Enumeration<String> getPrefixes(String uri) {
        return super.getPrefixes(uri);
    }

    @Override
    public Enumeration<String> getPrefixes() {
        return super.getPrefixes();
    }

    public QName toQName(String qname) {
        String prefix = "";
        String localName = qname;
        int colon = qname.indexOf(58);
        if (colon != -1) {
            prefix = qname.substring(0, colon);
            localName = qname.substring(colon + 1);
        }
        return new QName(this.getURI(prefix), localName, prefix);
    }

    public void startDocument() {
        this.reset();
        this.needNewContext = true;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this.needNewContext) {
            this.pushContext();
            this.needNewContext = false;
        }
        this.declarePrefix(prefix, uri);
    }

    public void startElement() {
        if (this.needNewContext) {
            this.pushContext();
        }
        this.needNewContext = true;
    }

    public void endElement() {
        this.popContext();
    }

    public static void main(String[] args) {
        MyNamespaceSupport ns = new MyNamespaceSupport();
        System.out.println(ns.declarePrefix("http://www.sonoasystems.com/schemas/2007/8/3/sci/"));
        System.out.println(ns.declarePrefix("http://www.sonoasystems.com/schemas/2007/8/7/sci/"));
        System.out.println(ns.declarePrefix("http://com"));
        System.out.println(ns.declarePrefix("http://google.org"));
    }
}

