/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.io.IOException;
import jlibs.nbp.NBParser;
import jlibs.xml.sax.async.AsyncXMLReader;
import org.apache.xerces.util.XMLChar;

public final class XMLScanner
extends NBParser {
    private static final int[][] STRING_IDS = new int[][]{new int[0], {110, 111}, {121, 101, 115}, {115, 116, 97, 110, 100, 97, 108, 111, 110, 101}, {101, 110, 99, 111, 100, 105, 110, 103}, {118, 101, 114, 115, 105, 111, 110}, {60, 33, 45, 45}, {60, 33, 91, 67, 68, 65, 84, 65, 91}, {67, 68, 65, 84, 65}, {60, 63, 120, 109, 108}, {83, 89, 83, 84, 69, 77}, {80, 85, 66, 76, 73, 67}, {78, 79, 84, 65, 84, 73, 79, 78}, {78, 68, 65, 84, 65}, {69, 78, 84, 73, 84, 89}, {69, 78, 84, 73, 84}, {78, 77, 84, 79, 75, 69, 78}, {35, 80, 67, 68, 65, 84, 65}, {82, 69, 81, 85, 73, 82, 69, 68}, {73, 77, 80, 76, 73, 69, 68}, {70, 73, 88, 69, 68}, {65, 84, 84, 76, 73, 83, 84}, {69, 76, 69, 77, 69, 78, 84}, {69, 77, 80, 84, 89}, {65, 78, 89}, {68, 79, 67, 84, 89, 80, 69}, {73, 71, 78, 79, 82, 69}, {73, 78, 67, 76, 85, 68, 69}};
    public static final int RULE_STR_NO = -1;
    public static final int RULE_STR_YES = -2;
    public static final int RULE_STR_STANDALONE = -3;
    public static final int RULE_STR_ENCODING = -4;
    public static final int RULE_STR_VERSION = -5;
    public static final int RULE_STR_COMMENT_START = -6;
    public static final int RULE_STR_CDATA_START = -7;
    public static final int RULE_STR_CDATA = -8;
    public static final int RULE_STR_XML = -9;
    public static final int RULE_STR_SYSTEM = -10;
    public static final int RULE_STR_PUBLIC = -11;
    public static final int RULE_STR_NOTATION = -12;
    public static final int RULE_STR_NDATA = -13;
    public static final int RULE_STR_ENTITY = -14;
    public static final int RULE_STR_ENTIT = -15;
    public static final int RULE_STR_NMTOKEN = -16;
    public static final int RULE_STR_HASH_PCDATA = -17;
    public static final int RULE_STR_REQUIRED = -18;
    public static final int RULE_STR_IMPLIED = -19;
    public static final int RULE_STR_FIXED = -20;
    public static final int RULE_STR_ATTLIST = -21;
    public static final int RULE_STR_ELEMENT = -22;
    public static final int RULE_STR_EMPTY = -23;
    public static final int RULE_STR_ANY = -24;
    public static final int RULE_STR_DOCTYPE = -25;
    public static final int RULE_STR_IGNORE = -26;
    public static final int RULE_STR_INCLUDE = -27;
    public static final int RULE_EQ = 0;
    public static final int RULE_YES_NO = 1;
    public static final int RULE_SD_DECL = 2;
    public static final int RULE_ENC_NAME = 3;
    public static final int RULE_ENC_DECL = 4;
    public static final int RULE_VERSION_NUM = 5;
    public static final int RULE_VERSION_INFO = 6;
    public static final int RULE_COMMENT = 7;
    public static final int RULE_CDATA_END = 8;
    public static final int RULE_CDATA = 9;
    public static final int RULE_NAME = 10;
    public static final int RULE_PI_TARGET = 11;
    public static final int RULE_PI = 12;
    public static final int RULE_NCNAME = 13;
    public static final int RULE_QNAME = 14;
    public static final int RULE_REFERENCE = 15;
    public static final int RULE_ATTR = 16;
    public static final int RULE_VALUE = 17;
    public static final int RULE_Q_VALUE = 18;
    public static final int RULE_DQ_VALUE = 19;
    public static final int RULE_ELEM_ATTRS = 20;
    public static final int RULE_XDECL = 21;
    public static final int RULE_MISC = 22;
    public static final int RULE_SYTEM_LITERAL = 23;
    public static final int RULE_PUBID_LITERAL = 24;
    public static final int RULE_SYSTEM_ID = 25;
    public static final int RULE_PUBLIC_ID = 26;
    public static final int RULE_NOTATION_DECL = 27;
    public static final int RULE_EXTERNAL_ID = 28;
    public static final int RULE_PE_REFERENCE = 29;
    public static final int RULE_NDATA_DECL = 30;
    public static final int RULE_PE_DEF = 31;
    public static final int RULE_ENTITY_VALUE = 32;
    public static final int RULE_Q_ENTITY_VALUE = 33;
    public static final int RULE_DQ_ENTITY_VALUE = 34;
    public static final int RULE_ENTITY_DECL = 35;
    public static final int RULE_ENTITY_DEF = 36;
    public static final int RULE_TOKENIZED_TYPE = 37;
    public static final int RULE_NMTOKEN = 38;
    public static final int RULE_ENUMERATION = 39;
    public static final int RULE_MIXED = 40;
    public static final int RULE_NOTATION_TYPE = 41;
    public static final int RULE_ENUMERATED_TYPE = 42;
    public static final int RULE_ATT_TYPE = 43;
    public static final int RULE_DEFAULT_DECL = 44;
    public static final int RULE_ATT_DEF = 45;
    public static final int RULE_ATT_LIST_DECL = 46;
    public static final int RULE_CHILDREN = 47;
    public static final int RULE_NAME_CARDINALITY = 48;
    public static final int RULE_DECL_SEP = 49;
    public static final int RULE_MARKUP_DECL = 50;
    public static final int RULE_ELEMENT_DECL = 51;
    public static final int RULE_INT_SUBSET = 52;
    public static final int RULE_DOCTYPE_DECL = 53;
    public static final int RULE_DOCUMENT = 54;
    public static final int RULE_ELEM = 55;
    public static final int RULE_ELEM_CONTENT = 56;
    public static final int RULE_TEXT_DECL = 57;
    public static final int RULE_IGNORE_SECT = 58;
    public static final int RULE_EXT_SUBSET_DECL = 59;
    public static final int RULE_CONDITIONAL_SECT = 60;
    public static final int RULE_INCLUDE_SECT = 61;
    public static final int RULE_EXTERNAL_ENTITY_VALUE = 62;
    public static final int RULE_INT_VALUE = 63;
    protected final AsyncXMLReader handler;

    private static boolean DIGIT(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private static boolean HEX_DIGIT(int ch) {
        return XMLScanner.DIGIT(ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private static boolean ENCODING_START(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
    }

    private static boolean ENCODING_PART(int ch) {
        return XMLScanner.ENCODING_START(ch) || XMLScanner.DIGIT(ch) || ch == 46 || ch == 95 || ch == 45;
    }

    private static boolean ELEM_CONTENT_CHAR(int ch) {
        return XMLChar.isValid((int)ch) && ch != 60 && ch != 38;
    }

    private static boolean ELEM_CONTENT_CHAR_NBRACE(int ch) {
        return XMLChar.isValid((int)ch) && ch != 60 && ch != 38 && ch != 93;
    }

    private static boolean ATTR_Q_CONTENT(int ch) {
        return XMLChar.isValid((int)ch) && ch != 60 && ch != 38 && ch != 39;
    }

    private static boolean ATTR_DQ_CONTENT(int ch) {
        return XMLChar.isValid((int)ch) && ch != 60 && ch != 38 && ch != 34;
    }

    private static boolean ENTITY_CONTENT(int ch) {
        return XMLChar.isValid((int)ch) && ch != 37 && ch != 38;
    }

    private static boolean ENTITY_Q_CONTENT(int ch) {
        return XMLChar.isValid((int)ch) && ch != 37 && ch != 38 && ch != 39;
    }

    private static boolean ENTITY_DQ_CONTENT(int ch) {
        return XMLChar.isValid((int)ch) && ch != 37 && ch != 38 && ch != 34;
    }

    private boolean eq(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.finishAll_WS(this.codePoint());
                if (ch == -2) break;
                if (ch == 61) {
                    ++this.position;
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"<WS> OR [=]"});
                }
            }
            case 1: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(0, state);
        return false;
    }

    private boolean yes_no(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 110) {
                    this.buffer.push();
                    state = 1;
                    if (!this.matchString(-1, 0, STRING_IDS[1])) {
                        break;
                    }
                } else {
                    this.buffer.push();
                    state = 1;
                    if (!this.matchString(-2, 0, STRING_IDS[2])) break;
                }
            }
            case 1: {
                this.handler.standalone(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(1, state);
        return false;
    }

    private boolean sd_decl(int state) throws Exception {
        block9: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-3, 0, STRING_IDS[3])) break block9;
                }
                case 1: {
                    state = 2;
                    if (!this.eq(0)) break block9;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        state = 5;
                        continue block9;
                    }
                    if (ch == 34) {
                        ++this.position;
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 3: {
                    state = 4;
                    if (!this.yes_no(0)) break block9;
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 34) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<DQ>"});
                }
                case 5: {
                    state = 6;
                    if (!this.yes_no(0)) break block9;
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<Q>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(2, state);
        return false;
    }

    private boolean enc_name(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (XMLScanner.ENCODING_START(ch)) {
                    this.buffer.push();
                    this.buffer.append(this.input[this.position++]);
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"<ENCODING_START>"});
                }
            }
            case 1: {
                if (this.finishAll_ENCODING_PART() == -2) break;
                this.handler.encoding(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(3, state);
        return false;
    }

    private boolean enc_decl(int state) throws Exception {
        block9: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-4, 0, STRING_IDS[4])) break block9;
                }
                case 1: {
                    state = 2;
                    if (!this.eq(0)) break block9;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        state = 5;
                        continue block9;
                    }
                    if (ch == 34) {
                        ++this.position;
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 3: {
                    state = 4;
                    if (!this.enc_name(0)) break block9;
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 34) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<DQ>"});
                }
                case 5: {
                    state = 6;
                    if (!this.enc_name(0)) break block9;
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<Q>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(4, state);
        return false;
    }

    private boolean version_num(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 49) {
                    this.buffer.push();
                    this.buffer.append(this.input[this.position++]);
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"[1]"});
                }
            }
            case 1: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 46) {
                    this.buffer.append(this.input[this.position++]);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"[\\.]"});
                }
            }
            case 2: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (XMLScanner.DIGIT(ch)) {
                    this.buffer.append(this.input[this.position++]);
                    state = 3;
                } else {
                    this.expected(ch, new String[]{"<DIGIT>"});
                }
            }
            case 3: {
                if (this.finishAll_DIGIT() == -2) break;
                this.handler.version(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(5, state);
        return false;
    }

    private boolean version_info(int state) throws Exception {
        block9: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-5, 0, STRING_IDS[5])) break block9;
                }
                case 1: {
                    state = 2;
                    if (!this.eq(0)) break block9;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        state = 5;
                        continue block9;
                    }
                    if (ch == 34) {
                        ++this.position;
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 3: {
                    state = 4;
                    if (!this.version_num(0)) break block9;
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 34) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<DQ>"});
                }
                case 5: {
                    state = 6;
                    if (!this.version_num(0)) break block9;
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block9;
                    if (ch == 39) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"<Q>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(6, state);
        return false;
    }

    private boolean comment(int state) throws Exception {
        block7: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-6, 0, STRING_IDS[6])) break block7;
                }
                case 1: {
                    this.buffer.push();
                    state = 2;
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block7;
                    if (ch == 45) {
                        this.buffer.append(this.input[this.position++]);
                        state = 3;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 2;
                            continue block7;
                        }
                        this.expected(ch, new String[]{"<DASH> OR <CHAR>"});
                    }
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block7;
                    if (ch == 45) {
                        this.buffer.append(this.input[this.position++]);
                        state = 4;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 2;
                            continue block7;
                        }
                        this.expected(ch, new String[]{"<DASH> OR <CHAR>"});
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 62) {
                        this.buffer.append(this.input[this.position++]);
                        this.handler.comment(this.buffer.pop(0, 3));
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(7, state);
        return false;
    }

    private boolean cdata_end(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 93) {
                        this.buffer.append(this.input[this.position++]);
                        state = 1;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 0;
                            continue block5;
                        }
                        this.expected(ch, new String[]{"<BRACKET_CLOSE> OR <CHAR>"});
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 93) {
                        this.buffer.append(this.input[this.position++]);
                        state = 2;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 0;
                            continue block5;
                        }
                        this.expected(ch, new String[]{"<BRACKET_CLOSE> OR <CHAR>"});
                    }
                }
                case 2: {
                    int ch = this.finishAll(this.codePoint(), 93);
                    if (ch == -2) break block5;
                    if (ch == 62) {
                        this.buffer.append(this.input[this.position++]);
                        return true;
                    }
                    if (ch != -1 && XMLChar.isValid((int)ch)) {
                        this.consume(ch);
                        state = 0;
                        continue block5;
                    }
                    this.expected(ch, new String[]{"<BRACKET_CLOSE> OR <GT> OR <CHAR>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(8, state);
        return false;
    }

    private boolean cdata(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.matchString(-7, 0, STRING_IDS[7])) break;
            }
            case 1: {
                this.buffer.push();
                state = 2;
                if (!this.cdata_end(0)) break;
            }
            case 2: {
                this.handler.cdata(this.buffer.pop(0, 3));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(9, state);
        return false;
    }

    private boolean name(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                    this.consume(ch);
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"<NAME_START>"});
                }
            }
            case 1: {
                if (this.finishAll_NAME_PART(this.codePoint()) == -2) break;
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(10, state);
        return false;
    }

    private boolean pi_target(int state) throws Exception {
        block7: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 120 || ch == 88) {
                        this.buffer.append(this.input[this.position++]);
                        state = 2;
                        continue block7;
                    }
                    if (ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                        this.buffer.append(this.input[this.position++]);
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[xX] OR <NCNAME_START>"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch != -1 && XMLChar.isNCName((int)ch)) {
                        this.buffer.append(this.input[this.position++]);
                        state = 1;
                        continue block7;
                    }
                    return true;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 109 || ch == 77) {
                        this.buffer.append(this.input[this.position++]);
                        state = 3;
                    } else {
                        state = 1;
                        continue block7;
                    }
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 108 || ch == 76) {
                        this.buffer.append(this.input[this.position++]);
                        state = 4;
                    } else {
                        state = 1;
                        continue block7;
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch != -1 && XMLChar.isNCName((int)ch)) {
                        this.buffer.append(this.input[this.position++]);
                        state = 1;
                        continue block7;
                    }
                    this.expected(ch, new String[]{"<NCNAME_PART>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(11, state);
        return false;
    }

    private boolean pi(int state) throws Exception {
        block10: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 63) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[?]"});
                    }
                }
                case 2: {
                    this.buffer.push();
                    state = 3;
                    if (!this.pi_target(0)) break block10;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block10;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.piTarget(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 5;
                        continue block10;
                    }
                    if (ch == 63) {
                        this.handler.piTarget(this.buffer.pop(0, 0));
                        this.handler.piData();
                        ++this.position;
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"<WS> OR [?]"});
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 62) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 5: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block10;
                    this.buffer.push();
                    state = 6;
                }
                case 6: {
                    int ch = this.codePoint();
                    if (ch == -2) break block10;
                    if (ch == 63) {
                        this.buffer.append(this.input[this.position++]);
                        state = 7;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 6;
                            continue block10;
                        }
                        this.expected(ch, new String[]{"[?] OR <CHAR>"});
                    }
                }
                case 7: {
                    int ch = this.finishAll(this.codePoint(), 63);
                    if (ch == -2) break block10;
                    if (ch == 62) {
                        this.handler.piData(this.buffer.pop(0, 1));
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isValid((int)ch)) {
                        this.consume(ch);
                        state = 6;
                        continue block10;
                    }
                    this.expected(ch, new String[]{"[?] OR [>] OR <CHAR>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(12, state);
        return false;
    }

    private boolean ncname(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                    this.buffer.append(this.input[this.position++]);
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"<NCNAME_START>"});
                }
            }
            case 1: {
                if (this.finishAll_NCNAME_PART() == -2) break;
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(13, state);
        return false;
    }

    private boolean qname(int state) throws Exception {
        switch (state) {
            case 0: {
                this.buffer.push();
                this.buffer.push();
                state = 1;
                if (!this.ncname(0)) break;
            }
            case 1: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 58) {
                    this.handler.prefix(this.buffer.pop(0, 0));
                    this.buffer.append(this.input[this.position++]);
                    state = 2;
                } else {
                    this.buffer.pop(0, 0);
                    this.handler.qname(this.buffer.pop(0, 0));
                    return true;
                }
            }
            case 2: {
                state = 3;
                if (!this.ncname(0)) break;
            }
            case 3: {
                this.handler.qname(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(14, state);
        return false;
    }

    private boolean reference(int state) throws Exception {
        block10: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 38) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[\\&]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 35) {
                        ++this.position;
                        state = 3;
                        continue block10;
                    }
                    this.buffer.push();
                    state = 2;
                    if (!this.name(0)) break block10;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 59) {
                        this.buffer.append(this.input[this.position++]);
                        this.handler.entityReference(this.buffer.pop(0, 1));
                        return !this.stop;
                    }
                    this.expected(ch, new String[]{"[;]"});
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 120) {
                        ++this.position;
                        this.handler.hexCode();
                        state = 6;
                        continue block10;
                    }
                    if (XMLScanner.DIGIT(ch)) {
                        this.handler.asciiCode();
                        this.buffer.push();
                        this.buffer.append(this.input[this.position++]);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"[x] OR <DIGIT>"});
                    }
                }
                case 4: {
                    if (this.finishAll_DIGIT() == -2) break block10;
                    state = 5;
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 59) {
                        this.buffer.append(this.input[this.position++]);
                        this.handler.charReference(this.buffer.pop(0, 1));
                        return true;
                    }
                    this.expected(ch, new String[]{"[;]"});
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (XMLScanner.HEX_DIGIT(ch)) {
                        this.buffer.push();
                        this.buffer.append(this.input[this.position++]);
                        state = 7;
                    } else {
                        this.expected(ch, new String[]{"<HEX_DIGIT>"});
                    }
                }
                case 7: {
                    if (this.finishAll_HEX_DIGIT() == -2) break block10;
                    state = 5;
                    continue block10;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(15, state);
        return false;
    }

    private boolean attr(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.qname(0)) break;
            }
            case 1: {
                state = 2;
                if (!this.eq(0)) break;
            }
            case 2: {
                state = 3;
                if (!this.value(0)) break;
            }
            case 3: {
                this.handler.attributeEnd();
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(16, state);
        return false;
    }

    private boolean value(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        this.handler.valueStart();
                        ++this.position;
                        state = 2;
                        continue block5;
                    }
                    if (ch == 34) {
                        this.handler.valueStart();
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 34) {
                        ++this.position;
                        this.handler.valueEnd();
                        return true;
                    }
                    state = 1;
                    if (!this.dq_value(0)) break block5;
                    continue block5;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        ++this.position;
                        this.handler.valueEnd();
                        return true;
                    }
                    state = 2;
                    if (!this.q_value(0)) break block5;
                    continue block5;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(17, state);
        return false;
    }

    private boolean q_value(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLScanner.ATTR_Q_CONTENT(ch)) {
                    this.buffer.push();
                    this.consume(ch);
                    state = 1;
                } else {
                    return this.reference(0);
                }
            }
            case 1: {
                if (this.finishAll_ATTR_Q_CONTENT(this.codePoint()) == -2) break;
                this.handler.rawValue(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(18, state);
        return false;
    }

    private boolean dq_value(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLScanner.ATTR_DQ_CONTENT(ch)) {
                    this.buffer.push();
                    this.consume(ch);
                    state = 1;
                } else {
                    return this.reference(0);
                }
            }
            case 1: {
                if (this.finishAll_ATTR_DQ_CONTENT(this.codePoint()) == -2) break;
                this.handler.rawValue(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(19, state);
        return false;
    }

    private boolean elem_attrs(int state) throws Exception {
        block8: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block8;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    state = 2;
                    if (!this.qname(0)) break block8;
                }
                case 2: {
                    this.handler.attributesStart();
                    state = 3;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        return true;
                    }
                }
                case 4: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                        state = 5;
                        if (!this.attr(0)) {
                            break block8;
                        }
                    } else {
                        return true;
                    }
                }
                case 5: {
                    state = 3;
                    continue block8;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(20, state);
        return false;
    }

    private boolean xdecl(int state) throws Exception {
        block13: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-9, 0, STRING_IDS[9])) break block13;
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 2: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    state = 3;
                    if (!this.version_info(0)) break block13;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 6;
                        continue block13;
                    }
                    state = 4;
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 63) {
                        ++this.position;
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"[?]"});
                    }
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        this.handler.xdeclEnd();
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 6: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 101) {
                        state = 9;
                        if (!this.enc_decl(0)) break block13;
                        continue block13;
                    }
                    if (ch == 63) {
                        state = 4;
                        continue block13;
                    }
                    state = 7;
                }
                case 7: {
                    state = 8;
                    if (!this.sd_decl(0)) break block13;
                }
                case 8: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    state = 4;
                    continue block13;
                }
                case 9: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 10;
                    } else {
                        state = 4;
                        continue block13;
                    }
                }
                case 10: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 115) {
                        state = 7;
                        continue block13;
                    }
                    state = 4;
                    continue block13;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(21, state);
        return false;
    }

    private boolean misc(int state) throws Exception {
        block4: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block4;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 1;
                        continue block4;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block4;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch == 33) {
                        this.resetLookAhead();
                        return this.comment(0);
                    }
                    this.resetLookAhead();
                    return this.pi(0);
                }
                case 1: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block4;
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(22, state);
        return false;
    }

    private boolean sytem_literal(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        ++this.position;
                        this.buffer.push();
                        state = 2;
                        continue block5;
                    }
                    if (ch == 34) {
                        ++this.position;
                        this.buffer.push();
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 34) {
                        this.handler.systemID(this.buffer.pop(0, 0));
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isValid((int)ch)) {
                        this.consume(ch);
                        state = 1;
                        continue block5;
                    }
                    this.expected(ch, new String[]{"<DQ> OR <CHAR>"});
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        this.handler.systemID(this.buffer.pop(0, 0));
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isValid((int)ch)) {
                        this.consume(ch);
                        state = 2;
                        continue block5;
                    }
                    this.expected(ch, new String[]{"<Q> OR <CHAR>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(23, state);
        return false;
    }

    private boolean pubid_literal(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 34) {
                        ++this.position;
                        this.buffer.push();
                        state = 2;
                        continue block5;
                    }
                    if (ch == 39) {
                        ++this.position;
                        this.buffer.push();
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"<DQ> OR <Q>"});
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        this.handler.publicID(this.buffer.pop(0, 0));
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isPubid((int)ch)) {
                        this.consume(ch);
                        state = 1;
                        continue block5;
                    }
                    this.expected(ch, new String[]{"<Q> OR <PUBID_CHAR>"});
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch == 34) {
                        this.handler.publicID(this.buffer.pop(0, 0));
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isPubid((int)ch)) {
                        this.consume(ch);
                        state = 2;
                        continue block5;
                    }
                    this.expected(ch, new String[]{"<DQ> OR <PUBID_CHAR>"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(24, state);
        return false;
    }

    private boolean system_id(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.matchString(-10, 0, STRING_IDS[10])) break;
            }
            case 1: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"<WS>"});
                }
            }
            case 2: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                return this.sytem_literal(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(25, state);
        return false;
    }

    private boolean public_id(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.matchString(-11, 0, STRING_IDS[11])) break;
            }
            case 1: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"<WS>"});
                }
            }
            case 2: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                return this.pubid_literal(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(26, state);
        return false;
    }

    private boolean notation_decl(int state) throws Exception {
        block13: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 33) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    state = 3;
                    if (!this.matchString(-12, 0, STRING_IDS[12])) break block13;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 4: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    this.buffer.push();
                    state = 5;
                    if (!this.ncname(0)) break block13;
                }
                case 5: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.notationName(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 6;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 6: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 80) {
                        state = 9;
                        if (!this.public_id(0)) break block13;
                        continue block13;
                    }
                    state = 7;
                    if (!this.system_id(0)) break block13;
                }
                case 7: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    state = 8;
                }
                case 8: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.notationEnd();
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 9: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 10;
                    } else {
                        state = 8;
                        continue block13;
                    }
                }
                case 10: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        state = 8;
                        continue block13;
                    }
                    state = 7;
                    if (!this.sytem_literal(0)) break block13;
                    continue block13;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(27, state);
        return false;
    }

    private boolean external_id(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 80) {
                    state = 1;
                    if (!this.public_id(0)) {
                        break;
                    }
                } else {
                    return this.system_id(0);
                }
            }
            case 1: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"<WS>"});
                }
            }
            case 2: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                return this.sytem_literal(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(28, state);
        return false;
    }

    private boolean pe_reference(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 37) {
                    ++this.position;
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"[%]"});
                }
            }
            case 1: {
                this.buffer.push();
                state = 2;
                if (!this.name(0)) break;
            }
            case 2: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 59) {
                    this.handler.peReference(this.buffer.pop(0, 0));
                    ++this.position;
                    return !this.stop;
                }
                this.expected(ch, new String[]{"[;]"});
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(29, state);
        return false;
    }

    private boolean ndata_decl(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.matchString(-13, 0, STRING_IDS[13])) break;
            }
            case 1: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"<WS>"});
                }
            }
            case 2: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                this.buffer.push();
                state = 3;
                if (!this.name(0)) break;
            }
            case 3: {
                this.handler.notationReference(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(30, state);
        return false;
    }

    private boolean pe_def(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 80) {
                    return this.external_id(0);
                }
                if (ch == 83) {
                    return this.external_id(0);
                }
                return this.entity_value(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(31, state);
        return false;
    }

    private boolean entity_value(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        this.handler.valueStart();
                        this.handler.entityValue();
                        ++this.position;
                        state = 2;
                        continue block5;
                    }
                    if (ch == 34) {
                        this.handler.valueStart();
                        this.handler.entityValue();
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"<Q> OR <DQ>"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 34) {
                        ++this.position;
                        this.handler.valueEnd();
                        return true;
                    }
                    state = 1;
                    if (!this.dq_entity_value(0)) break block5;
                    continue block5;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block5;
                    if (ch == 39) {
                        ++this.position;
                        this.handler.valueEnd();
                        return true;
                    }
                    state = 2;
                    if (!this.q_entity_value(0)) break block5;
                    continue block5;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(32, state);
        return false;
    }

    private boolean q_entity_value(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_Q_CONTENT(ch)) {
                        this.buffer.push();
                        state = 1;
                    } else {
                        if (ch == 38) {
                            return this.reference(0);
                        }
                        return this.pe_reference(0);
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_Q_CONTENT(ch)) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<ENTITY_Q_CONTENT>"});
                    }
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_Q_CONTENT(ch)) {
                        state = 1;
                        continue block5;
                    }
                    this.handler.rawValue(this.buffer.pop(0, 0));
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(33, state);
        return false;
    }

    private boolean dq_entity_value(int state) throws Exception {
        block5: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_DQ_CONTENT(ch)) {
                        this.buffer.push();
                        state = 1;
                    } else {
                        if (ch == 38) {
                            return this.reference(0);
                        }
                        return this.pe_reference(0);
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_DQ_CONTENT(ch)) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<ENTITY_DQ_CONTENT>"});
                    }
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block5;
                    if (ch != -1 && XMLScanner.ENTITY_DQ_CONTENT(ch)) {
                        state = 1;
                        continue block5;
                    }
                    this.handler.rawValue(this.buffer.pop(0, 0));
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(34, state);
        return false;
    }

    private boolean entity_decl(int state) throws Exception {
        block15: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 33) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    state = 3;
                    if (!this.matchString(-14, 0, STRING_IDS[14])) break block15;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 4: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch == 37) {
                        ++this.position;
                        state = 8;
                        continue block15;
                    }
                    this.buffer.push();
                    state = 5;
                    if (!this.ncname(0)) break block15;
                }
                case 5: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.entityName(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 6;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 6: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    state = 7;
                    if (!this.entity_def(0)) break block15;
                }
                case 7: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.entityEnd();
                        return true;
                    }
                    this.expected(ch, new String[]{"<WS> OR [>]"});
                }
                case 8: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 9;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 9: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    this.buffer.push();
                    state = 10;
                    if (!this.ncname(0)) break block15;
                }
                case 10: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.paramEntityName(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 11;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 11: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    state = 12;
                    if (!this.pe_def(0)) break block15;
                }
                case 12: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.paramEntityEnd();
                        return true;
                    }
                    this.expected(ch, new String[]{"<WS> OR [>]"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(35, state);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean entity_def(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 80) {
                    state = 1;
                    if (!this.external_id(0)) {
                        break;
                    }
                } else {
                    if (ch != 83) {
                        return this.entity_value(0);
                    }
                    state = 1;
                    if (!this.external_id(0)) break;
                }
            }
            case 1: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 2;
                } else {
                    return true;
                }
            }
            case 2: {
                int ch = this.finishAll_WS(this.codePoint());
                if (ch == -2) break;
                if (ch == 78) {
                    return this.ndata_decl(0);
                }
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(36, state);
        return false;
    }

    private boolean tokenized_type(int state) throws Exception {
        block12: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 69) {
                        state = 7;
                        if (!this.matchString(-15, 0, STRING_IDS[15])) break block12;
                        continue block12;
                    }
                    if (ch == 73) {
                        ++this.position;
                        state = 2;
                        continue block12;
                    }
                    state = 1;
                    if (!this.matchString(-16, 0, STRING_IDS[16])) break block12;
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 83) {
                        ++this.position;
                        this.handler.nmtokensAttribute();
                        return true;
                    }
                    this.handler.nmtokenAttribute();
                    return true;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 68) {
                        ++this.position;
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"[D]"});
                    }
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 82) {
                        ++this.position;
                        state = 4;
                    } else {
                        this.handler.idAttribute();
                        return true;
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 69) {
                        ++this.position;
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"[E]"});
                    }
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 70) {
                        ++this.position;
                        state = 6;
                    } else {
                        this.expected(ch, new String[]{"[F]"});
                    }
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 83) {
                        ++this.position;
                        this.handler.idRefsAttribute();
                        return true;
                    }
                    this.handler.idRefAttribute();
                    return true;
                }
                case 7: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 89) {
                        ++this.position;
                        this.handler.entityAttribute();
                        return true;
                    }
                    if (ch == 73) {
                        ++this.position;
                        state = 8;
                    } else {
                        this.expected(ch, new String[]{"[Y] OR [I]"});
                    }
                }
                case 8: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 69) {
                        ++this.position;
                        state = 9;
                    } else {
                        this.expected(ch, new String[]{"[E]"});
                    }
                }
                case 9: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block12;
                    if (ch == 83) {
                        ++this.position;
                        this.handler.entitiesAttribute();
                        return true;
                    }
                    this.expected(ch, new String[]{"[S]"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(37, state);
        return false;
    }

    private boolean nmtoken(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isName((int)ch)) {
                    this.consume(ch);
                    state = 1;
                } else {
                    this.expected(ch, new String[]{"<NAME_PART>"});
                }
            }
            case 1: {
                if (this.finishAll_NAME_PART(this.codePoint()) == -2) break;
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(38, state);
        return false;
    }

    private boolean enumeration(int state) throws Exception {
        block11: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block11;
                    if (ch == 40) {
                        this.handler.enumerationAttribute();
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[(]"});
                    }
                }
                case 1: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block11;
                    this.buffer.push();
                    state = 2;
                    if (!this.nmtoken(0)) break block11;
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block11;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 8;
                        continue block11;
                    }
                    if (ch == 124) {
                        this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                        state = 4;
                        continue block11;
                    }
                    this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                    state = 3;
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block11;
                    if (ch == 41) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[)]"});
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block11;
                    if (ch == 124) {
                        ++this.position;
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"[|]"});
                    }
                }
                case 5: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block11;
                    this.buffer.push();
                    state = 6;
                    if (!this.nmtoken(0)) break block11;
                }
                case 6: {
                    int ch = this.codePoint();
                    if (ch == -2) break block11;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 7;
                    } else {
                        if (ch == 124) {
                            this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                            state = 4;
                            continue block11;
                        }
                        this.handler.attributeEnumValue(this.buffer.pop(0, 0));
                        state = 3;
                        continue block11;
                    }
                }
                case 7: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block11;
                    if (ch == 124) {
                        state = 4;
                        continue block11;
                    }
                    state = 3;
                    continue block11;
                }
                case 8: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block11;
                    if (ch == 124) {
                        state = 4;
                        continue block11;
                    }
                    state = 3;
                    continue block11;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(39, state);
        return false;
    }

    private boolean mixed(int state) throws Exception {
        block15: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 40) {
                        this.consume(ch);
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[(]"});
                    }
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 11;
                        continue block15;
                    }
                    if (ch == 35) {
                        state = 2;
                        if (!this.matchString(-17, 0, STRING_IDS[17])) {
                            break block15;
                        }
                    } else {
                        state = 1;
                        if (!this.pe_reference(0)) break block15;
                        continue block15;
                    }
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch == 124) {
                        state = 6;
                        continue block15;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 5;
                        continue block15;
                    }
                    if (ch == 37) {
                        state = 2;
                        if (!this.pe_reference(0)) break block15;
                        continue block15;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block15;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 41) {
                        if (ch == 42) {
                            state = 3;
                            this.resetLookAhead();
                            continue block15;
                        }
                        this.consume(-2);
                        this.resetLookAhead();
                        return true;
                    }
                    this.expected(ch, new String[]{"[|] OR <WS> OR [%] OR [)][*] OR [)]<EOF>"});
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 41) {
                        ++this.position;
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"[)]"});
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 42) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[*]"});
                }
                case 5: {
                    int ch = this.codePoint();
                    if (ch == -2 || (ch = this.finishAll_WS(ch)) == -2) break block15;
                    if (ch == 124) {
                        state = 6;
                        continue block15;
                    }
                    if (ch == 37) {
                        state = 2;
                        if (!this.pe_reference(0)) break block15;
                        continue block15;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block15;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 41) {
                        if (ch == 42) {
                            state = 3;
                            this.resetLookAhead();
                            continue block15;
                        }
                        this.consume(-2);
                        this.resetLookAhead();
                        return true;
                    }
                    this.expected(ch, new String[]{"<WS> OR [|] OR [%] OR [)][*] OR [)]<EOF>"});
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 124) {
                        ++this.position;
                        state = 7;
                    } else {
                        this.expected(ch, new String[]{"[|]"});
                    }
                }
                case 7: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 10;
                        continue block15;
                    }
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 8;
                        if (!this.name(0)) {
                            break block15;
                        }
                    } else {
                        state = 7;
                        if (!this.pe_reference(0)) break block15;
                        continue block15;
                    }
                }
                case 8: {
                    int ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 9;
                    } else {
                        if (ch == 124) {
                            state = 6;
                            continue block15;
                        }
                        if (ch == 41) {
                            state = 3;
                            continue block15;
                        }
                        state = 8;
                        if (!this.pe_reference(0)) break block15;
                        continue block15;
                    }
                }
                case 9: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch == 124) {
                        state = 6;
                        continue block15;
                    }
                    if (ch == 41) {
                        state = 3;
                        continue block15;
                    }
                    state = 8;
                    if (!this.pe_reference(0)) break block15;
                    continue block15;
                }
                case 10: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 8;
                        if (!this.name(0)) break block15;
                        continue block15;
                    }
                    state = 7;
                    if (!this.pe_reference(0)) break block15;
                    continue block15;
                }
                case 11: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch == 35) {
                        state = 2;
                        if (!this.matchString(-17, 0, STRING_IDS[17])) break block15;
                        continue block15;
                    }
                    state = 1;
                    if (!this.pe_reference(0)) break block15;
                    continue block15;
                }
                case 12: {
                    state = 2;
                    if (!this.matchString(-17, 0, STRING_IDS[17])) break block15;
                    continue block15;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(40, state);
        return false;
    }

    private boolean notation_type(int state) throws Exception {
        block13: while (true) {
            switch (state) {
                case 0: {
                    this.handler.notationAttribute();
                    state = 1;
                    if (!this.matchString(-12, 0, STRING_IDS[12])) break block13;
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 2: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 40) {
                        ++this.position;
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"<WS> OR [(]"});
                    }
                }
                case 3: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    this.buffer.push();
                    state = 4;
                    if (!this.name(0)) break block13;
                }
                case 4: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 10;
                        continue block13;
                    }
                    if (ch == 124) {
                        this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                        state = 6;
                        continue block13;
                    }
                    this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                    state = 5;
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 41) {
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[)]"});
                }
                case 6: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 124) {
                        ++this.position;
                        state = 7;
                    } else {
                        this.expected(ch, new String[]{"[|]"});
                    }
                }
                case 7: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block13;
                    this.buffer.push();
                    state = 8;
                    if (!this.name(0)) break block13;
                }
                case 8: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 9;
                    } else {
                        if (ch == 124) {
                            this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                            state = 6;
                            continue block13;
                        }
                        this.handler.attributeNotationValue(this.buffer.pop(0, 0));
                        state = 5;
                        continue block13;
                    }
                }
                case 9: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 124) {
                        state = 6;
                        continue block13;
                    }
                    state = 5;
                    continue block13;
                }
                case 10: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 124) {
                        state = 6;
                        continue block13;
                    }
                    state = 5;
                    continue block13;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(41, state);
        return false;
    }

    private boolean enumerated_type(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 78) {
                    return this.notation_type(0);
                }
                return this.enumeration(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(42, state);
        return false;
    }

    private boolean att_type(int state) throws Exception {
        block4: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block4;
                    if (ch == 67) {
                        state = 1;
                        if (!this.matchString(-8, 0, STRING_IDS[8])) break block4;
                        continue block4;
                    }
                    if (ch == 40) {
                        return this.enumerated_type(0);
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block4;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 78 && ch == 79) {
                        this.resetLookAhead();
                        return this.enumerated_type(0);
                    }
                    this.resetLookAhead();
                    return this.tokenized_type(0);
                }
                case 1: {
                    this.handler.cdataAttribute();
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(43, state);
        return false;
    }

    private boolean default_decl(int state) throws Exception {
        block10: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 35) {
                        ++this.position;
                        state = 2;
                        continue block10;
                    }
                    state = 1;
                    if (!this.value(0)) break block10;
                }
                case 1: {
                    this.handler.attributeDefaultValue();
                    return true;
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 82) {
                        state = 7;
                        if (!this.matchString(-18, 0, STRING_IDS[18])) break block10;
                        continue block10;
                    }
                    if (ch == 73) {
                        state = 6;
                        if (!this.matchString(-19, 0, STRING_IDS[19])) break block10;
                        continue block10;
                    }
                    state = 3;
                    if (!this.matchString(-20, 0, STRING_IDS[20])) break block10;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block10;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 4: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block10;
                    state = 5;
                    if (!this.value(0)) break block10;
                }
                case 5: {
                    this.handler.attributeFixedValue();
                    return true;
                }
                case 6: {
                    this.handler.attributeImplied();
                    return true;
                }
                case 7: {
                    this.handler.attributeRequired();
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(44, state);
        return false;
    }

    private boolean att_def(int state) throws Exception {
        block8: while (true) {
            switch (state) {
                case 0: {
                    this.buffer.push();
                    state = 1;
                    if (!this.name(0)) break block8;
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.dtdAttribute(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 2: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block8;
                    state = 3;
                    if (!this.att_type(0)) break block8;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        state = 3;
                        if (!this.pe_reference(0)) break block8;
                        continue block8;
                    }
                }
                case 4: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 5;
                    } else {
                        if (ch == 37) {
                            state = 4;
                            if (!this.pe_reference(0)) break block8;
                            continue block8;
                        }
                        return this.default_decl(0);
                    }
                }
                case 5: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block8;
                    if (ch == 37) {
                        state = 4;
                        if (!this.pe_reference(0)) break block8;
                        continue block8;
                    }
                    return this.default_decl(0);
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(45, state);
        return false;
    }

    private boolean att_list_decl(int state) throws Exception {
        block14: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block14;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block14;
                    if (ch == 33) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    state = 3;
                    if (!this.matchString(-21, 0, STRING_IDS[21])) break block14;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        state = 3;
                        if (!this.pe_reference(0)) break block14;
                        continue block14;
                    }
                }
                case 4: {
                    int ch = this.codePoint();
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 11;
                        continue block14;
                    }
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        this.buffer.push();
                        state = 5;
                        if (!this.name(0)) {
                            break block14;
                        }
                    } else {
                        state = 4;
                        if (!this.pe_reference(0)) break block14;
                        continue block14;
                    }
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block14;
                    if (ch == 62) {
                        this.handler.dtdAttributesStart(this.buffer.pop(0, 0));
                        state = 10;
                        continue block14;
                    }
                    this.handler.dtdAttributesStart(this.buffer.pop(0, 0));
                    state = 6;
                }
                case 6: {
                    int ch = this.codePoint();
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 7;
                    } else {
                        state = 6;
                        if (!this.pe_reference(0)) break block14;
                        continue block14;
                    }
                }
                case 7: {
                    int ch = this.codePoint();
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 9;
                        if (!this.att_def(0)) break block14;
                        continue block14;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 8;
                    } else {
                        if (ch == 62) {
                            state = 10;
                            continue block14;
                        }
                        state = 7;
                        if (!this.pe_reference(0)) break block14;
                        continue block14;
                    }
                }
                case 8: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 9;
                        if (!this.att_def(0)) {
                            break block14;
                        }
                    } else {
                        if (ch == 62) {
                            state = 10;
                            continue block14;
                        }
                        state = 7;
                        if (!this.pe_reference(0)) break block14;
                        continue block14;
                    }
                }
                case 9: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block14;
                    if (ch == 62) {
                        state = 10;
                    } else {
                        state = 6;
                        continue block14;
                    }
                }
                case 10: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block14;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.dtdAttributesEnd();
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 11: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block14;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        this.buffer.push();
                        state = 5;
                        if (!this.name(0)) break block14;
                        continue block14;
                    }
                    state = 4;
                    if (!this.pe_reference(0)) break block14;
                    continue block14;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(46, state);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean children(int state) throws Exception {
        block20: while (true) {
            switch (state) {
                case 0: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 40) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[(]"});
                    }
                }
                case 1: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 16;
                        continue block20;
                    }
                    if (ch != 40) ** GOTO lbl23
                    state = 2;
                    if (!this.children(0)) {
                        break block20;
                    }
                    ** GOTO lbl31
lbl23:
                    // 1 sources

                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 2;
                        if (!this.name_cardinality(0)) {
                            break block20;
                        }
                    } else {
                        state = 1;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
lbl31:
                // 3 sources

                case 2: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch == 124) {
                        state = 11;
                        continue block20;
                    }
                    if (ch == 44) {
                        state = 6;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 3;
                    } else {
                        state = 2;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 3: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch == 124) {
                        state = 11;
                        continue block20;
                    }
                    if (ch == 44) {
                        state = 6;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                    } else {
                        state = 2;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 4: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 41) {
                        ++this.position;
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"[)]"});
                    }
                }
                case 5: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 63 || ch == 43 || ch == 42) {
                        ++this.position;
                        return true;
                    }
                    return true;
                }
                case 6: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 44) {
                        ++this.position;
                        state = 7;
                    } else {
                        this.expected(ch, new String[]{"[,]"});
                    }
                }
                case 7: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 9;
                        if (!this.name_cardinality(0)) break block20;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 8;
                    } else {
                        if (ch == 40) {
                            state = 9;
                            if (!this.children(0)) break block20;
                            continue block20;
                        }
                        state = 7;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 8: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch == -1 || !XMLChar.isNameStart((int)ch)) ** GOTO lbl114
                    state = 9;
                    if (!this.name_cardinality(0)) {
                        break block20;
                    }
                    ** GOTO lbl122
lbl114:
                    // 1 sources

                    if (ch == 40) {
                        state = 9;
                        if (!this.children(0)) {
                            break block20;
                        }
                    } else {
                        state = 7;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
lbl122:
                // 3 sources

                case 9: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch == 44) {
                        state = 6;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 10;
                    } else {
                        state = 9;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 10: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch == 44) {
                        state = 6;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                        continue block20;
                    }
                    state = 9;
                    if (!this.pe_reference(0)) break block20;
                    continue block20;
                }
                case 11: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 124) {
                        ++this.position;
                        state = 12;
                    } else {
                        this.expected(ch, new String[]{"[|]"});
                    }
                }
                case 12: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch == 40) {
                        state = 14;
                        if (!this.children(0)) break block20;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 13;
                    } else {
                        if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                            state = 14;
                            if (!this.name_cardinality(0)) break block20;
                            continue block20;
                        }
                        state = 12;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 13: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch != 40) ** GOTO lbl184
                    state = 14;
                    if (!this.children(0)) {
                        break block20;
                    }
                    ** GOTO lbl192
lbl184:
                    // 1 sources

                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 14;
                        if (!this.name_cardinality(0)) {
                            break block20;
                        }
                    } else {
                        state = 12;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
lbl192:
                // 3 sources

                case 14: {
                    ch = this.codePoint();
                    if (ch == -2) break block20;
                    if (ch == 124) {
                        state = 11;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 15;
                    } else {
                        state = 14;
                        if (!this.pe_reference(0)) break block20;
                        continue block20;
                    }
                }
                case 15: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch == 124) {
                        state = 11;
                        continue block20;
                    }
                    if (ch == 41) {
                        state = 4;
                        continue block20;
                    }
                    state = 14;
                    if (!this.pe_reference(0)) break block20;
                    continue block20;
                }
                case 16: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block20;
                    if (ch == 40) {
                        state = 2;
                        if (!this.children(0)) break block20;
                        continue block20;
                    }
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        state = 2;
                        if (!this.name_cardinality(0)) break block20;
                        continue block20;
                    }
                    state = 1;
                    if (!this.pe_reference(0)) break block20;
                    continue block20;
                }
                case 17: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block20;
                    if (ch == 40) {
                        state = 2;
                        if (!this.children(0)) break block20;
                        continue block20;
                    }
                    state = 2;
                    if (!this.name_cardinality(0)) break block20;
                    continue block20;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(47, state);
        return false;
    }

    private boolean name_cardinality(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.name(0)) break;
            }
            case 1: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 63 || ch == 42 || ch == 43) {
                    ++this.position;
                    return true;
                }
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(48, state);
        return false;
    }

    private boolean decl_sep(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isSpace((int)ch)) {
                    this.consume(ch);
                    state = 1;
                } else {
                    this.handler.peReferenceOutsideMarkup();
                    return this.pe_reference(0);
                }
            }
            case 1: {
                if (this.finishAll_WS(this.codePoint()) == -2) break;
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(49, state);
        return false;
    }

    private boolean markup_decl(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                this.addToLookAhead(ch);
                if (ch != -1) {
                    ch = this.codePoint();
                    if (ch == -2) break;
                    this.addToLookAhead(ch);
                }
                if (this.laLen == 2 && this.la[0] == 60 && ch == 63) {
                    this.resetLookAhead();
                    return this.pi(0);
                }
                if (ch != -1) {
                    ch = this.codePoint();
                    if (ch == -2) break;
                    this.addToLookAhead(ch);
                }
                if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33) {
                    if (ch == 65) {
                        this.resetLookAhead();
                        return this.att_list_decl(0);
                    }
                    if (ch == 78) {
                        this.resetLookAhead();
                        return this.notation_decl(0);
                    }
                    if (ch == 45) {
                        this.resetLookAhead();
                        return this.comment(0);
                    }
                }
                if (ch != -1) {
                    ch = this.codePoint();
                    if (ch == -2) break;
                    this.addToLookAhead(ch);
                }
                if (this.laLen == 4 && this.la[0] == 60 && this.la[1] == 33 && this.la[2] == 69 && ch == 76) {
                    this.resetLookAhead();
                    return this.element_decl(0);
                }
                this.resetLookAhead();
                return this.entity_decl(0);
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(50, state);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean element_decl(int state) throws Exception {
        block17: while (true) {
            switch (state) {
                case 0: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block17;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block17;
                    if (ch == 33) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    state = 3;
                    if (!this.matchString(-22, 0, XMLScanner.STRING_IDS[22])) break block17;
                }
                case 3: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        state = 3;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
                case 4: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 14;
                        continue block17;
                    }
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        this.buffer.push();
                        state = 5;
                        if (!this.name(0)) {
                            break block17;
                        }
                    } else {
                        state = 4;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
                case 5: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.dtdElement(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 7;
                        continue block17;
                    }
                    this.handler.dtdElement(this.buffer.pop(0, 0));
                    state = 6;
                    if (!this.pe_reference(0)) break block17;
                }
                case 6: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 7;
                    } else {
                        state = 6;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
                case 7: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch == 40) {
                        ++this.position;
                        state = 11;
                        continue block17;
                    }
                    if (ch == 69) {
                        this.handler.notMixed();
                        state = 9;
                        if (!this.matchString(-23, 0, XMLScanner.STRING_IDS[23])) break block17;
                        continue block17;
                    }
                    if (ch == 65) {
                        state = 9;
                        if (!this.matchString(-24, 0, XMLScanner.STRING_IDS[24])) break block17;
                        continue block17;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 8;
                    } else {
                        state = 7;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
                case 8: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block17;
                    if (ch == 40) {
                        ++this.position;
                        state = 11;
                        continue block17;
                    }
                    if (ch != 69) ** GOTO lbl105
                    this.handler.notMixed();
                    state = 9;
                    if (!this.matchString(-23, 0, XMLScanner.STRING_IDS[23])) {
                        break block17;
                    }
                    ** GOTO lbl113
lbl105:
                    // 1 sources

                    if (ch == 65) {
                        state = 9;
                        if (!this.matchString(-24, 0, XMLScanner.STRING_IDS[24])) {
                            break block17;
                        }
                    } else {
                        state = 7;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
lbl113:
                // 3 sources

                case 9: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch == 62) {
                        ++this.position;
                        return true;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 10;
                    } else {
                        state = 9;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                }
                case 10: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block17;
                    if (ch == 62) {
                        ++this.position;
                        return true;
                    }
                    state = 9;
                    if (!this.pe_reference(0)) break block17;
                    continue block17;
                }
                case 11: {
                    ch = this.codePoint();
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 13;
                        continue block17;
                    }
                    if (ch == 37) {
                        state = 11;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                    if (ch == 35) {
                        state = 12;
                        if (!this.mixed(12)) {
                            break block17;
                        }
                    } else {
                        this.handler.notMixed();
                        state = 12;
                        if (!this.children(17)) break block17;
                    }
                }
                case 12: {
                    state = 9;
                    continue block17;
                }
                case 13: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block17;
                    if (ch == 37) {
                        state = 11;
                        if (!this.pe_reference(0)) break block17;
                        continue block17;
                    }
                    if (ch == 35) {
                        state = 12;
                        if (!this.mixed(12)) break block17;
                        continue block17;
                    }
                    this.handler.notMixed();
                    state = 12;
                    if (!this.children(17)) break block17;
                    continue block17;
                }
                case 14: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block17;
                    if (ch != -1 && XMLChar.isNameStart((int)ch)) {
                        this.buffer.push();
                        state = 5;
                        if (!this.name(0)) break block17;
                        continue block17;
                    }
                    state = 4;
                    if (!this.pe_reference(0)) break block17;
                    continue block17;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(51, state);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean int_subset(int state) throws Exception {
        block4: while (true) {
            switch (state) {
                case 0: {
                    ch = this.codePoint();
                    if (ch == -2) break block4;
                    if (ch != 37) ** GOTO lbl11
                    state = 1;
                    if (!this.decl_sep(0)) {
                        break block4;
                    }
                    ** GOTO lbl18
lbl11:
                    // 1 sources

                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 1;
                        if (!this.decl_sep(0)) {
                            break block4;
                        }
                    } else {
                        state = 1;
                        if (!this.markup_decl(0)) break block4;
                    }
                }
lbl18:
                // 4 sources

                case 1: {
                    ch = this.codePoint();
                    if (ch == -2) break block4;
                    if (ch == 37) {
                        state = 1;
                        if (!this.decl_sep(0)) break block4;
                        continue block4;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 1;
                        if (!this.decl_sep(0)) break block4;
                        continue block4;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block4;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch == 63) {
                        this.resetLookAhead();
                        state = 1;
                        if (!this.markup_decl(0)) break block4;
                        continue block4;
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block4;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33) {
                        if (ch == 65) {
                            this.resetLookAhead();
                            state = 1;
                            if (!this.markup_decl(0)) break block4;
                            continue block4;
                        }
                        if (ch == 78) {
                            this.resetLookAhead();
                            state = 1;
                            if (!this.markup_decl(0)) break block4;
                            continue block4;
                        }
                        if (ch == 45) {
                            this.resetLookAhead();
                            state = 1;
                            if (!this.markup_decl(0)) break block4;
                            continue block4;
                        }
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block4;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 4 && this.la[0] == 60 && this.la[1] == 33 && this.la[2] == 69) {
                        if (ch == 76) {
                            this.resetLookAhead();
                            state = 1;
                            if (!this.markup_decl(0)) break block4;
                            continue block4;
                        }
                        if (ch == 78) {
                            this.resetLookAhead();
                            state = 1;
                            if (!this.markup_decl(0)) break block4;
                            continue block4;
                        }
                    }
                    this.resetLookAhead();
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(52, state);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doctype_decl(int state) throws Exception {
        block15: while (true) {
            switch (state) {
                case 0: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 60) {
                        ++this.position;
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 33) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    state = 3;
                    if (!this.matchString(-25, 0, XMLScanner.STRING_IDS[25])) break block15;
                }
                case 3: {
                    ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 4: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    this.buffer.push();
                    state = 5;
                    if (!this.name(0)) break block15;
                }
                case 5: {
                    ch = this.codePoint();
                    if (ch == -2) break block15;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.handler.dtdRoot(this.buffer.pop(0, 0));
                        this.consume(ch);
                        state = 11;
                        continue block15;
                    }
                    this.handler.dtdRoot(this.buffer.pop(0, 0));
                    state = 6;
                }
                case 6: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 91) {
                        this.handler.dtdStart();
                        ++this.position;
                        state = 8;
                        continue block15;
                    }
                    this.handler.dtdStart();
                    state = 7;
                }
                case 7: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.dtdEnd();
                        return this.stop == false;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 8: {
                    state = 9;
                    if (!this.int_subset(0)) break block15;
                }
                case 9: {
                    ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block15;
                    if (ch == 93) {
                        ++this.position;
                        state = 10;
                    } else {
                        this.expected(ch, new String[]{"[\\]]"});
                    }
                }
                case 10: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    state = 7;
                    continue block15;
                }
                case 11: {
                    ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block15;
                    if (ch != 80) ** GOTO lbl86
                    state = 12;
                    if (!this.external_id(0)) {
                        break block15;
                    }
                    ** GOTO lbl93
lbl86:
                    // 1 sources

                    if (ch == 83) {
                        state = 12;
                        if (!this.external_id(0)) {
                            break block15;
                        }
                    } else {
                        state = 6;
                        continue block15;
                    }
                }
lbl93:
                // 3 sources

                case 12: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block15;
                    state = 6;
                    continue block15;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(53, state);
        return false;
    }

    private boolean document(int state) throws Exception {
        block6: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                        state = 2;
                        this.resetLookAhead();
                        continue block6;
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33 && ch == 68) {
                        this.resetLookAhead();
                        state = 1;
                        if (!this.doctype_decl(0)) break block6;
                        continue block6;
                    }
                    this.resetLookAhead();
                    state = 0;
                    if (!this.misc(0)) break block6;
                    continue block6;
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                        state = 2;
                        this.resetLookAhead();
                        continue block6;
                    }
                    this.resetLookAhead();
                    state = 1;
                    if (!this.misc(0)) break block6;
                    continue block6;
                }
                case 2: {
                    state = 3;
                    if (!this.elem(0)) break block6;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 3;
                        if (!this.misc(0)) break block6;
                        continue block6;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60) {
                        if (ch == 33) {
                            this.resetLookAhead();
                            state = 3;
                            if (!this.misc(0)) break block6;
                            continue block6;
                        }
                        if (ch == 63) {
                            this.resetLookAhead();
                            state = 3;
                            if (!this.misc(0)) break block6;
                            continue block6;
                        }
                    }
                    this.resetLookAhead();
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(54, state);
        return false;
    }

    private boolean elem(int state) throws Exception {
        block7: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.elem_attrs(0)) break block7;
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 47) {
                        ++this.position;
                        state = 4;
                        continue block7;
                    }
                    if (ch == 62) {
                        ++this.position;
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[/] OR [>]"});
                    }
                }
                case 2: {
                    this.handler.attributesEnd();
                    state = 3;
                    if (!this.elem_content(0)) break block7;
                }
                case 3: {
                    this.handler.rootElementEnd();
                    return true;
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 62) {
                        this.handler.attributesEnd();
                        ++this.position;
                        this.handler.elementEnd();
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(55, state);
        return false;
    }

    private boolean elem_content(int state) throws Exception {
        block13: while (true) {
            switch (state) {
                case 0: {
                    this.buffer.push();
                    state = 1;
                }
                case 1: {
                    int ch = this.finishAll_ELEM_CONTENT_CHAR_NBRACE(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 93) {
                        this.buffer.append(this.input[this.position++]);
                        state = 9;
                        continue block13;
                    }
                    state = 2;
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch == 38) {
                        this.handler.characters(this.buffer.pop(0, 0));
                        state = 8;
                        if (!this.reference(0)) break block13;
                        continue block13;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block13;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60) {
                        if (ch == 47) {
                            this.handler.characters(this.buffer.pop(0, 0));
                            this.consume(-2);
                            state = 5;
                            this.resetLookAhead();
                            continue block13;
                        }
                        if (ch != -1 && XMLChar.isNCNameStart((int)ch)) {
                            this.handler.characters(this.buffer.pop(0, 0));
                            this.resetLookAhead();
                            state = 3;
                            if (!this.elem_attrs(0)) break block13;
                            continue block13;
                        }
                        if (ch == 63) {
                            this.handler.characters(this.buffer.pop(0, 0));
                            this.resetLookAhead();
                            state = 8;
                            if (!this.pi(0)) break block13;
                            continue block13;
                        }
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block13;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33) {
                        if (ch == 45) {
                            this.handler.characters(this.buffer.pop(0, 0));
                            this.resetLookAhead();
                            state = 8;
                            if (!this.comment(0)) break block13;
                            continue block13;
                        }
                        if (ch == 91) {
                            this.handler.characters(this.buffer.pop(0, 0));
                            this.resetLookAhead();
                            state = 8;
                            if (!this.cdata(0)) break block13;
                            continue block13;
                        }
                    }
                    this.handler.characters(this.buffer.pop(0, 0));
                    this.resetLookAhead();
                    return true;
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 47) {
                        ++this.position;
                        state = 4;
                    } else {
                        if (ch == 62) {
                            ++this.position;
                            this.handler.attributesEnd();
                            state = 8;
                            continue block13;
                        }
                        this.expected(ch, new String[]{"[/] OR [>]"});
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        this.handler.attributesEnd();
                        ++this.position;
                        this.handler.elementEnd();
                        state = 8;
                        continue block13;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 47) {
                        this.handler.endingElem();
                        ++this.position;
                        state = 6;
                    } else {
                        this.expected(ch, new String[]{"[/]"});
                    }
                }
                case 6: {
                    state = 7;
                    if (!this.matchString(0, this.dynamicStringToBeMatched)) break block13;
                }
                case 7: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        ++this.position;
                        this.handler.elementEnd();
                        state = 8;
                        if (this.stop) {
                            break block13;
                        }
                    } else {
                        this.expected(ch, new String[]{"<WS> OR [>]"});
                    }
                }
                case 8: {
                    this.buffer.push();
                    state = 1;
                    continue block13;
                }
                case 9: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch == 93) {
                        this.buffer.append(this.input[this.position++]);
                        state = 10;
                    } else {
                        if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                            this.consume(ch);
                            state = 1;
                            continue block13;
                        }
                        state = 2;
                        continue block13;
                    }
                }
                case 10: {
                    int ch = this.finishAll(this.codePoint(), 93);
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        this.buffer.append(this.input[this.position++]);
                        this.handler.fatalError("Text may not contain a literal ']]>' sequence");
                        return true;
                    }
                    if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                        this.consume(ch);
                        state = 1;
                        continue block13;
                    }
                    state = 2;
                    continue block13;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(56, state);
        return false;
    }

    private boolean text_decl(int state) throws Exception {
        block10: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-9, 0, STRING_IDS[9])) break block10;
                }
                case 1: {
                    int ch = this.codePoint();
                    if (ch == -2) break block10;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 2: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block10;
                    if (ch == 118) {
                        state = 6;
                        if (!this.version_info(0)) break block10;
                        continue block10;
                    }
                    state = 3;
                }
                case 3: {
                    state = 4;
                    if (!this.enc_decl(0)) break block10;
                }
                case 4: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block10;
                    if (ch == 63) {
                        ++this.position;
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"<WS> OR [?]"});
                    }
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block10;
                    if (ch == 62) {
                        this.handler.xdeclEnd();
                        ++this.position;
                        return true;
                    }
                    this.expected(ch, new String[]{"[>]"});
                }
                case 6: {
                    int ch = this.codePoint();
                    if (ch == -2) break block10;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 7;
                    } else {
                        this.expected(ch, new String[]{"<WS>"});
                    }
                }
                case 7: {
                    if (this.finishAll_WS(this.codePoint()) == -2) break block10;
                    state = 3;
                    continue block10;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(57, state);
        return false;
    }

    private boolean ignore_sect(int state) throws Exception {
        block13: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    if (!this.matchString(-26, 0, STRING_IDS[26])) break block13;
                }
                case 1: {
                    int ch = this.finishAll_WS(this.codePoint());
                    if (ch == -2) break block13;
                    if (ch == 91) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"<WS> OR [\\[]"});
                    }
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch == 93) {
                        this.consume(ch);
                        state = 8;
                        continue block13;
                    }
                    if (ch == 60) {
                        state = 3;
                    } else {
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 2;
                            continue block13;
                        }
                        this.expected(ch, new String[]{"[\\]] OR [<] OR <CHAR>"});
                    }
                }
                case 3: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 60) {
                        this.consume(ch);
                        state = 4;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 4: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 33) {
                        this.consume(ch);
                        state = 5;
                    } else {
                        state = 2;
                        continue block13;
                    }
                }
                case 5: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block13;
                    if (ch == 91) {
                        this.consume(ch);
                        state = 6;
                    } else {
                        state = 2;
                        continue block13;
                    }
                }
                case 6: {
                    state = 7;
                    if (!this.ignore_sect(10)) break block13;
                }
                case 7: {
                    state = 2;
                    continue block13;
                }
                case 8: {
                    int ch = this.codePoint();
                    if (ch == -2) break block13;
                    if (ch == 93) {
                        this.consume(ch);
                        state = 9;
                    } else {
                        if (ch == 60) {
                            state = 3;
                            continue block13;
                        }
                        if (ch != -1 && XMLChar.isValid((int)ch)) {
                            this.consume(ch);
                            state = 2;
                            continue block13;
                        }
                        this.expected(ch, new String[]{"[\\]] OR [<] OR <CHAR>"});
                    }
                }
                case 9: {
                    int ch = this.finishAll(this.codePoint(), 93);
                    if (ch == -2) break block13;
                    if (ch == 62) {
                        this.consume(ch);
                        return true;
                    }
                    if (ch == 60) {
                        state = 3;
                        continue block13;
                    }
                    if (ch != -1 && XMLChar.isValid((int)ch)) {
                        this.consume(ch);
                        state = 2;
                        continue block13;
                    }
                    this.expected(ch, new String[]{"[\\]] OR [>] OR [<] OR <CHAR>"});
                }
                case 10: {
                    state = 2;
                    continue block13;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(58, state);
        return false;
    }

    private boolean ext_subset_decl(int state) throws Exception {
        block6: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    if (ch == 37) {
                        state = 2;
                        continue block6;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 2;
                        continue block6;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch == 63) {
                        state = 2;
                        this.resetLookAhead();
                        continue block6;
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33) {
                        if (ch == 65) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 78) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 45) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 91) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 4 && this.la[0] == 60 && this.la[1] == 33 && this.la[2] == 69) {
                        if (ch == 76) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 78) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                    }
                    state = 1;
                    this.resetLookAhead();
                    continue block6;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    if (ch == 37) {
                        state = 3;
                        if (!this.decl_sep(0)) break block6;
                        continue block6;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 3;
                        if (!this.decl_sep(0)) break block6;
                        continue block6;
                    }
                    this.addToLookAhead(ch);
                    while (ch != -1 && this.laLen < 3) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33 && ch == 91) {
                        this.resetLookAhead();
                        state = 3;
                        if (!this.conditional_sect(0)) break block6;
                        continue block6;
                    }
                    this.resetLookAhead();
                    state = 3;
                    if (!this.markup_decl(0)) break block6;
                    continue block6;
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block6;
                    if (ch == 37) {
                        state = 2;
                        continue block6;
                    }
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        state = 2;
                        continue block6;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 60 && ch == 63) {
                        state = 2;
                        this.resetLookAhead();
                        continue block6;
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 3 && this.la[0] == 60 && this.la[1] == 33) {
                        if (ch == 65) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 78) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 45) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 91) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                    }
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block6;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 4 && this.la[0] == 60 && this.la[1] == 33 && this.la[2] == 69) {
                        if (ch == 76) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                        if (ch == 78) {
                            state = 2;
                            this.resetLookAhead();
                            continue block6;
                        }
                    }
                    state = 1;
                    this.resetLookAhead();
                    continue block6;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(59, state);
        return false;
    }

    private boolean conditional_sect(int state) throws Exception {
        block7: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 60) {
                        this.consume(ch);
                        state = 1;
                    } else {
                        this.expected(ch, new String[]{"[<]"});
                    }
                }
                case 1: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 33) {
                        this.consume(ch);
                        state = 2;
                    } else {
                        this.expected(ch, new String[]{"[!]"});
                    }
                }
                case 2: {
                    int ch = this.position == this.limit ? this.marker : this.input[this.position];
                    if (ch == -2) break block7;
                    if (ch == 91) {
                        this.consume(ch);
                        state = 3;
                    } else {
                        this.expected(ch, new String[]{"[\\[]"});
                    }
                }
                case 3: {
                    int ch = this.codePoint();
                    if (ch == -2) break block7;
                    if (ch != -1 && XMLChar.isSpace((int)ch)) {
                        this.consume(ch);
                        state = 4;
                        continue block7;
                    }
                    if (ch == 37) {
                        state = 3;
                        if (!this.pe_reference(0)) break block7;
                        continue block7;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block7;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 73 && ch == 71) {
                        this.resetLookAhead();
                        return this.ignore_sect(0);
                    }
                    this.resetLookAhead();
                    return this.include_sect(0);
                }
                case 4: {
                    int ch = this.codePoint();
                    if (ch == -2 || (ch = this.finishAll_WS(ch)) == -2) break block7;
                    if (ch == 37) {
                        state = 3;
                        if (!this.pe_reference(0)) break block7;
                        continue block7;
                    }
                    this.addToLookAhead(ch);
                    if (ch != -1) {
                        ch = this.codePoint();
                        if (ch == -2) break block7;
                        this.addToLookAhead(ch);
                    }
                    if (this.laLen == 2 && this.la[0] == 73 && ch == 71) {
                        this.resetLookAhead();
                        return this.ignore_sect(0);
                    }
                    this.resetLookAhead();
                    return this.include_sect(0);
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(60, state);
        return false;
    }

    private boolean include_sect(int state) throws Exception {
        switch (state) {
            case 0: {
                state = 1;
                if (!this.matchString(-27, 0, STRING_IDS[27])) break;
            }
            case 1: {
                int ch = this.finishAll_WS(this.codePoint());
                if (ch == -2) break;
                if (ch == 91) {
                    this.consume(ch);
                    state = 2;
                } else {
                    this.expected(ch, new String[]{"<WS> OR [\\[]"});
                }
            }
            case 2: {
                state = 3;
                if (!this.ext_subset_decl(0)) break;
            }
            case 3: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 93) {
                    this.consume(ch);
                    state = 4;
                } else {
                    this.expected(ch, new String[]{"[\\]]"});
                }
            }
            case 4: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 93) {
                    this.consume(ch);
                    state = 5;
                } else {
                    this.expected(ch, new String[]{"[\\]]"});
                }
            }
            case 5: {
                int ch = this.position == this.limit ? this.marker : this.input[this.position];
                if (ch == -2) break;
                if (ch == 62) {
                    this.consume(ch);
                    return true;
                }
                this.expected(ch, new String[]{"[>]"});
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(61, state);
        return false;
    }

    private boolean external_entity_value(int state) throws Exception {
        switch (state) {
            case 0: {
                int ch = this.codePoint();
                if (ch == -2) break;
                if (ch != -1 && XMLChar.isValid((int)ch)) {
                    this.buffer.push();
                    this.consume(ch);
                    state = 1;
                } else {
                    this.buffer.push();
                    this.handler.externalEntityValue(this.buffer.pop(0, 0));
                    return true;
                }
            }
            case 1: {
                if (this.finishAll_CHAR(this.codePoint()) == -2) break;
                this.handler.externalEntityValue(this.buffer.pop(0, 0));
                return true;
            }
            default: {
                throw new Error("impossible state: " + state);
            }
        }
        this.exiting(62, state);
        return false;
    }

    private boolean int_value(int state) throws Exception {
        block8: while (true) {
            switch (state) {
                case 0: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                        state = 3;
                        continue block8;
                    }
                    if (ch == 38) {
                        state = 1;
                    } else {
                        return true;
                    }
                }
                case 1: {
                    state = 2;
                    if (!this.reference(0)) break block8;
                }
                case 2: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                        state = 3;
                    } else {
                        if (ch == 38) {
                            state = 1;
                            continue block8;
                        }
                        return true;
                    }
                }
                case 3: {
                    this.buffer.push();
                    state = 4;
                }
                case 4: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                        this.consume(ch);
                        state = 5;
                    } else {
                        this.expected(ch, new String[]{"<ELEM_CONTENT_CHAR>"});
                    }
                }
                case 5: {
                    int ch = this.codePoint();
                    if (ch == -2) break block8;
                    if (ch == 38) {
                        this.handler.rawValue(this.buffer.pop(0, 0));
                        state = 1;
                        continue block8;
                    }
                    if (ch != -1 && XMLScanner.ELEM_CONTENT_CHAR(ch)) {
                        state = 4;
                        continue block8;
                    }
                    this.handler.rawValue(this.buffer.pop(0, 0));
                    return true;
                }
                default: {
                    throw new Error("impossible state: " + state);
                }
            }
            break;
        }
        this.exiting(63, state);
        return false;
    }

    private int finishAll_WS(int ch) throws IOException {
        while (ch >= 0 && XMLChar.isSpace((int)ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    private int finishAll_ENCODING_PART() throws IOException {
        int _position = this.position;
        while (this.position < this.limit && XMLScanner.ENCODING_PART(this.input[this.position])) {
            ++this.position;
        }
        int len = this.position - _position;
        if (len > 0 && this.buffer.isBuffering()) {
            this.buffer.append(this.input, _position, len);
        }
        return this.codePoint();
    }

    private int finishAll_DIGIT() throws IOException {
        int _position = this.position;
        while (this.position < this.limit && XMLScanner.DIGIT(this.input[this.position])) {
            ++this.position;
        }
        int len = this.position - _position;
        if (len > 0 && this.buffer.isBuffering()) {
            this.buffer.append(this.input, _position, len);
        }
        return this.codePoint();
    }

    private int finishAll_NAME_PART(int ch) throws IOException {
        while (ch >= 0 && XMLChar.isName((int)ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    private int finishAll_NCNAME_PART() throws IOException {
        int _position = this.position;
        while (this.position < this.limit && XMLChar.isNCName((int)this.input[this.position])) {
            ++this.position;
        }
        int len = this.position - _position;
        if (len > 0 && this.buffer.isBuffering()) {
            this.buffer.append(this.input, _position, len);
        }
        return this.codePoint();
    }

    private int finishAll_HEX_DIGIT() throws IOException {
        int _position = this.position;
        while (this.position < this.limit && XMLScanner.HEX_DIGIT(this.input[this.position])) {
            ++this.position;
        }
        int len = this.position - _position;
        if (len > 0 && this.buffer.isBuffering()) {
            this.buffer.append(this.input, _position, len);
        }
        return this.codePoint();
    }

    private int finishAll_ATTR_Q_CONTENT(int ch) throws IOException {
        while (ch >= 0 && XMLScanner.ATTR_Q_CONTENT(ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    private int finishAll_ATTR_DQ_CONTENT(int ch) throws IOException {
        while (ch >= 0 && XMLScanner.ATTR_DQ_CONTENT(ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    private int finishAll_ELEM_CONTENT_CHAR_NBRACE(int ch) throws IOException {
        while (ch >= 0 && XMLScanner.ELEM_CONTENT_CHAR_NBRACE(ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    private int finishAll_CHAR(int ch) throws IOException {
        while (ch >= 0 && XMLChar.isValid((int)ch)) {
            this.consume(ch);
            ch = this.codePoint();
        }
        return ch;
    }

    protected final boolean callRule(int rule, int state) throws Exception {
        if (rule < 0) {
            if (rule == Integer.MIN_VALUE) {
                return this.matchString(state, this.dynamicStringToBeMatched);
            }
            return this.matchString(rule, state, STRING_IDS[-rule]);
        }
        switch (rule) {
            case 0: {
                return this.eq(state);
            }
            case 1: {
                return this.yes_no(state);
            }
            case 2: {
                return this.sd_decl(state);
            }
            case 3: {
                return this.enc_name(state);
            }
            case 4: {
                return this.enc_decl(state);
            }
            case 5: {
                return this.version_num(state);
            }
            case 6: {
                return this.version_info(state);
            }
            case 7: {
                return this.comment(state);
            }
            case 8: {
                return this.cdata_end(state);
            }
            case 9: {
                return this.cdata(state);
            }
            case 10: {
                return this.name(state);
            }
            case 11: {
                return this.pi_target(state);
            }
            case 12: {
                return this.pi(state);
            }
            case 13: {
                return this.ncname(state);
            }
            case 14: {
                return this.qname(state);
            }
            case 15: {
                return this.reference(state);
            }
            case 16: {
                return this.attr(state);
            }
            case 17: {
                return this.value(state);
            }
            case 18: {
                return this.q_value(state);
            }
            case 19: {
                return this.dq_value(state);
            }
            case 20: {
                return this.elem_attrs(state);
            }
            case 21: {
                return this.xdecl(state);
            }
            case 22: {
                return this.misc(state);
            }
            case 23: {
                return this.sytem_literal(state);
            }
            case 24: {
                return this.pubid_literal(state);
            }
            case 25: {
                return this.system_id(state);
            }
            case 26: {
                return this.public_id(state);
            }
            case 27: {
                return this.notation_decl(state);
            }
            case 28: {
                return this.external_id(state);
            }
            case 29: {
                return this.pe_reference(state);
            }
            case 30: {
                return this.ndata_decl(state);
            }
            case 31: {
                return this.pe_def(state);
            }
            case 32: {
                return this.entity_value(state);
            }
            case 33: {
                return this.q_entity_value(state);
            }
            case 34: {
                return this.dq_entity_value(state);
            }
            case 35: {
                return this.entity_decl(state);
            }
            case 36: {
                return this.entity_def(state);
            }
            case 37: {
                return this.tokenized_type(state);
            }
            case 38: {
                return this.nmtoken(state);
            }
            case 39: {
                return this.enumeration(state);
            }
            case 40: {
                return this.mixed(state);
            }
            case 41: {
                return this.notation_type(state);
            }
            case 42: {
                return this.enumerated_type(state);
            }
            case 43: {
                return this.att_type(state);
            }
            case 44: {
                return this.default_decl(state);
            }
            case 45: {
                return this.att_def(state);
            }
            case 46: {
                return this.att_list_decl(state);
            }
            case 47: {
                return this.children(state);
            }
            case 48: {
                return this.name_cardinality(state);
            }
            case 49: {
                return this.decl_sep(state);
            }
            case 50: {
                return this.markup_decl(state);
            }
            case 51: {
                return this.element_decl(state);
            }
            case 52: {
                return this.int_subset(state);
            }
            case 53: {
                return this.doctype_decl(state);
            }
            case 54: {
                return this.document(state);
            }
            case 55: {
                return this.elem(state);
            }
            case 56: {
                return this.elem_content(state);
            }
            case 57: {
                return this.text_decl(state);
            }
            case 58: {
                return this.ignore_sect(state);
            }
            case 59: {
                return this.ext_subset_decl(state);
            }
            case 60: {
                return this.conditional_sect(state);
            }
            case 61: {
                return this.include_sect(state);
            }
            case 62: {
                return this.external_entity_value(state);
            }
            case 63: {
                return this.int_value(state);
            }
        }
        throw new Error("impossible rule: " + this.stack[this.free - 2]);
    }

    public void onSuccessful() throws Exception {
        this.handler.onSuccessful();
    }

    public void fatalError(String message) throws Exception {
        this.handler.fatalError(message);
    }

    public XMLScanner(AsyncXMLReader handler, int startingRule) {
        super(4, startingRule);
        this.handler = handler;
    }
}

