/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.util.List;

public enum AttributeType {
    CDATA,
    ENUMERATION,
    ID,
    IDREF,
    IDREFS,
    NMTOKEN,
    NMTOKENS,
    ENTITY,
    ENTITIES,
    NOTATION;


    public String normalize(String value) {
        switch (this) {
            case NMTOKEN: 
            case ENTITY: 
            case ID: 
            case IDREF: 
            case ENUMERATION: {
                return value.trim();
            }
            case NMTOKENS: 
            case ENTITIES: 
            case IDREFS: {
                return AttributeType.toNMTOKENS(value);
            }
        }
        return value;
    }

    public String toString(List<String> validValues) {
        switch (this) {
            case ENUMERATION: 
            case NOTATION: {
                StringBuilder buff = new StringBuilder();
                if (this == NOTATION) {
                    buff.append(this.name()).append(' ');
                }
                buff.append('(');
                for (int i = 0; i < validValues.size(); ++i) {
                    if (i > 0) {
                        buff.append('|');
                    }
                    buff.append(validValues.get(i));
                }
                buff.append(')');
                return buff.toString();
            }
        }
        return this.name();
    }

    private static String toNMTOKENS(String value) {
        int len;
        int read;
        char[] buffer = value.toCharArray();
        int write = 0;
        int lastWrite = 0;
        boolean wroteOne = false;
        for (read = 0; read < buffer.length && buffer[read] == ' '; ++read) {
        }
        for (len = buffer.length; len < read && buffer[read] == ' '; --len) {
        }
        while (read < len) {
            if (buffer[read] == ' ') {
                if (wroteOne) {
                    buffer[write++] = 32;
                }
                while (++read < len && buffer[read] == ' ') {
                }
                continue;
            }
            buffer[write++] = buffer[read++];
            wroteOne = true;
            lastWrite = write;
        }
        value = new String(buffer, 0, lastWrite);
        return value;
    }

    public static String toPublicID(String value) {
        int len;
        int read;
        char[] buffer = value.toCharArray();
        int write = 0;
        int lastWrite = 0;
        boolean wroteOne = false;
        for (read = 0; read < buffer.length && Character.isWhitespace(buffer[read]); ++read) {
        }
        for (len = buffer.length; len < read && Character.isWhitespace(buffer[read]); --len) {
        }
        while (read < len) {
            if (Character.isWhitespace(buffer[read])) {
                if (wroteOne) {
                    buffer[write++] = 32;
                }
                while (++read < len && Character.isWhitespace(buffer[read])) {
                }
                continue;
            }
            buffer[write++] = buffer[read++];
            wroteOne = true;
            lastWrite = write;
        }
        value = new String(buffer, 0, lastWrite);
        return value;
    }
}

