/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AcrylLookAndFeel.getWindowBorderColor());
        } else {
            graphics.setColor(AcrylLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - this.buttonsWidth - 4;
        int n5 = n = bl ? 2 : n2 - 2;
        if (this.getWindowDecorationStyle() == 1) {
            int n6 = this.menuBar.getWidth() + 2;
            n += bl ? n6 : -n6;
            n4 -= n3;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.getTitle(), fontMetrics, n4);
        if (string != null) {
            int n7 = fontMetrics.stringWidth(string);
            int n8 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1;
            if (!bl) {
                n -= n7;
            }
            graphics.setColor(ColorHelper.darker(AcrylLookAndFeel.getWindowTitleColorDark(), 30.0));
            JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n8 - 1);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n8 + 1);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n8 - 1);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n8 + 1);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n8 + 1);
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n8);
            this.paintText(graphics, n, n8, string);
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        protected int computeHeight() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(AcrylTitlePane.this.getFont());
            return fontMetrics.getHeight() + 6;
        }

        public void layoutContainer(Container container) {
            boolean bl = AcrylTitlePane.this.isLeftToRight();
            int n = AcrylTitlePane.this.getHorSpacing();
            int n2 = AcrylTitlePane.this.getWidth();
            int n3 = AcrylTitlePane.this.getHeight();
            int n4 = n3 - AcrylTitlePane.this.getVerSpacing();
            int n5 = n4 + 10;
            int n6 = bl ? n : n2 - n5 - n;
            int n7 = Math.max(0, (n3 - n4) / 2 - 1);
            int n8 = 0;
            int n9 = 0;
            int n10 = AcrylTitlePane.this.getWidth();
            int n11 = AcrylTitlePane.this.getHeight();
            if (AcrylTitlePane.this.menuBar != null) {
                int n12 = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                int n13 = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().height;
                if (bl) {
                    n8 = 4 + n12;
                    AcrylTitlePane.this.menuBar.setBounds(2, (n3 - n13) / 2, n12, n13);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - n12, (n3 - n13) / 2, n12, n13);
                }
                n10 -= 4 + n12;
            }
            int n14 = n6 = bl ? n2 - n : 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            AcrylTitlePane.this.buttonsWidth = bl ? n2 - n6 : n6;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                if (!bl) {
                    n8 += AcrylTitlePane.this.buttonsWidth;
                }
                n10 -= AcrylTitlePane.this.buttonsWidth;
                Graphics graphics = AcrylTitlePane.this.getGraphics();
                if (graphics != null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n15 = SwingUtilities.computeStringWidth(fontMetrics, JTattooUtilities.getClippedText(AcrylTitlePane.this.getTitle(), fontMetrics, n10));
                    if (bl) {
                        n8 += n15;
                    }
                    n10 -= n15;
                }
                AcrylTitlePane.this.customTitlePanel.setBounds(n8, n9, n10, n11);
            }
        }
    }
}

