/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class BaseProgressBarUI
extends BasicProgressBarUI {
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(UIManager.getBorder("ProgressBar.border"));
        this.propertyChangeListener = new PropertyChangeHandler();
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallUI(jComponent);
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected Color getSelectionForeground() {
        Object object = this.progressBar.getClientProperty("selectionForeground");
        if (object instanceof Color) {
            return (Color)object;
        }
        return super.getSelectionForeground();
    }

    protected Color getSelectionBackground() {
        Object object = this.progressBar.getClientProperty("selectionBackground");
        if (object instanceof Color) {
            return (Color)object;
        }
        return super.getSelectionBackground();
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        Color color;
        Color color2;
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Color[] colorArray = null;
        if (this.progressBar.getForeground() instanceof UIResource) {
            colorArray = !JTattooUtilities.isActive(jComponent) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jComponent.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        } else {
            color2 = ColorHelper.brighter(this.progressBar.getForeground(), 40.0);
            color = ColorHelper.darker(this.progressBar.getForeground(), 20.0);
            colorArray = ColorHelper.createColorArr(color2, color, 20);
        }
        color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
        color = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
        Rectangle rectangle = this.getBox(null);
        if (rectangle != null) {
            graphics2D.setColor(this.progressBar.getForeground());
            JTattooUtilities.draw3DBorder(graphics, color2, color, rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        }
        if (this.progressBar.isStringPainted()) {
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, rectangle.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, rectangle.height, insets);
            }
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        Color color;
        Color color2;
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        Color[] colorArray = null;
        if (this.progressBar.getForeground() instanceof UIResource) {
            colorArray = !JTattooUtilities.isActive(jComponent) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jComponent.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        } else {
            color2 = ColorHelper.brighter(this.progressBar.getForeground(), 40.0);
            color = ColorHelper.darker(this.progressBar.getForeground(), 20.0);
            colorArray = ColorHelper.createColorArr(color2, color, 20);
        }
        color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
        color = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
        if (this.progressBar.getOrientation() == 0) {
            if (JTattooUtilities.isLeftToRight(this.progressBar)) {
                JTattooUtilities.draw3DBorder(graphics, color2, color, 2, 2, n3 - 2, n2 - 2);
                JTattooUtilities.fillHorGradient(graphics, colorArray, 3, 3, n3 - 4, n2 - 4);
            } else {
                JTattooUtilities.draw3DBorder(graphics, color2, color, n - n3 + 2, 2, n - 2, n2 - 2);
                JTattooUtilities.fillHorGradient(graphics, colorArray, n - n3 + 3, 3, n - 4, n2 - 4);
            }
        } else {
            JTattooUtilities.draw3DBorder(graphics, color2, color, 2, 2, n - 2, n3 - 2);
            JTattooUtilities.fillVerGradient(graphics, colorArray, 3, 3, n - 4, n3 - 4);
        }
        if (this.progressBar.isStringPainted()) {
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            this.paintString(graphics, insets.left, insets.top, n, n2, n3, insets);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            if (this.progressBar.isIndeterminate()) {
                this.paintIndeterminate(graphics, jComponent);
            } else {
                this.paintDeterminate(graphics, jComponent);
            }
        } else {
            this.paintDeterminate(graphics, jComponent);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionForeground".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof Color) {
                BaseProgressBarUI.this.progressBar.invalidate();
                BaseProgressBarUI.this.progressBar.repaint();
            } else if ("selectionBackground".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof Color) {
                BaseProgressBarUI.this.progressBar.invalidate();
                BaseProgressBarUI.this.progressBar.repaint();
            }
        }
    }
}

