/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.JTextComponent;

public class BaseEditorPaneUI
extends BasicEditorPaneUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseEditorPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.updateBackground();
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (BaseEditorPaneUI.this.getComponent() != null) {
                        BaseEditorPaneUI.this.orgBorder = BaseEditorPaneUI.this.getComponent().getBorder();
                        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                        if (lookAndFeel instanceof AbstractLookAndFeel && BaseEditorPaneUI.this.orgBorder instanceof UIResource) {
                            Border border = ((AbstractLookAndFeel)lookAndFeel).getBorderFactory().getFocusFrameBorder();
                            BaseEditorPaneUI.this.getComponent().setBorder(border);
                        }
                        BaseEditorPaneUI.this.getComponent().invalidate();
                        BaseEditorPaneUI.this.getComponent().repaint();
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (BaseEditorPaneUI.this.getComponent() != null) {
                        BaseEditorPaneUI.this.getComponent().setBorder(BaseEditorPaneUI.this.orgBorder);
                        BaseEditorPaneUI.this.getComponent().invalidate();
                        BaseEditorPaneUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    private void updateBackground() {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getBackground() instanceof UIResource) {
            if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
                jTextComponent.setBackground(AbstractLookAndFeel.getDisabledBackgroundColor());
            } else {
                jTextComponent.setBackground(AbstractLookAndFeel.getInputBackgroundColor());
            }
        }
    }
}

