/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class ScriptUtils {
    private ScriptUtils() {
    }

    public static Object evaluateJavaScript(String script) throws PluginImplementationException {
        ScriptEngine engine = ScriptUtils.getJavaScriptEngine();
        try {
            return engine.eval(script);
        }
        catch (Exception e) {
            throw new PluginImplementationException("Script execution failed", e);
        }
    }

    public static String evaluateJavaScriptToString(String script) throws PluginImplementationException {
        Object result = ScriptUtils.evaluateJavaScript(script);
        if (result == null || result instanceof String) {
            return (String)result;
        }
        throw new PluginImplementationException("Wrong script return type: " + result.getClass().getName() + ", expected String");
    }

    public static Number evaluateJavaScriptToNumber(String script) throws PluginImplementationException {
        Object result = ScriptUtils.evaluateJavaScript(script);
        if (result == null || result instanceof Number) {
            return (Number)result;
        }
        throw new PluginImplementationException("Wrong script return type: " + result.getClass().getName() + ", expected Number");
    }

    private static ScriptEngine getJavaScriptEngine() {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        if (engine == null) {
            throw new RuntimeException("JavaScript engine not found");
        }
        return engine;
    }
}

