/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.sandbox.SpeedMonitor;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.jdesktop.application.Action;

public class SpeedMeterDialog
extends AppFrame
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SpeedMeterDialog.class.getName());
    private final ManagerDirector director;
    private SpeedMonitor comp;
    private TimerTask task;
    private JButton cancelButton;

    public SpeedMeterDialog(Frame owner, ManagerDirector director) throws HeadlessException {
        super(owner);
        this.director = director;
        this.setName("SpeedMeterDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            this.doClose();
        }
    }

    @Action
    public void cancelBtnAction() {
        if (this.task != null) {
            logger.info("Stopping update timer");
            this.task.cancel();
        }
        this.doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    private void build() {
        this.cancelButton = new JButton();
        this.setAction(this.cancelButton, "cancelBtnAction");
        Timer timer = new Timer();
        this.task = new TimerTask(){

            @Override
            public void run() {
            }
        };
        timer.schedule(this.task, 300L, 1000L);
    }

    private void initComponents() {
        this.comp = new SpeedMonitor();
        this.getContentPane().add((Component)this.comp);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.comp.setCurrentSpeed(((Float)evt.getNewValue()).floatValue());
    }
}

