/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.PropertyOption;
import org.apache.commons.cli2.util.HelpFormatter;

final class CmdLine {
    private final MainApp app;
    private Map<String, String> properties = new HashMap<String, String>(2);
    private boolean resetOptions;
    private boolean minimize;
    private boolean nosplash;

    CmdLine(MainApp app) {
        this.app = app;
        this.resetOptions = false;
        this.minimize = false;
        this.nosplash = false;
    }

    private void showVersion() {
        System.out.println("FreeRapid 0.9u4");
        System.out.println("DevTeam (c) 2008-2014");
        this.app.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> processCommandLine(String[] args) {
        String appPath = Utils.getAppPath();
        File startup = new File(appPath, "startup.properties");
        if (startup.exists() && startup.isFile() && startup.canRead()) {
            Scanner scanner = null;
            LinkedList<String> list = new LinkedList<String>();
            try {
                scanner = new Scanner(startup);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty() || line.startsWith("#")) continue;
                    list.add(line);
                }
                if (!list.isEmpty()) {
                    list.addAll(Arrays.asList(args));
                    args = new String[list.size()];
                    list.toArray(args);
                }
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        if (args.length == 0) {
            return new LinkedList<String>();
        }
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption helpOption = obuilder.withShortName("h").withShortName("?").withLongName("help").withDescription("print this message").create();
        DefaultOption versionOption = obuilder.withShortName("v").withLongName("version").withDescription("print the version information and exit").create();
        DefaultOption debugOption = obuilder.withShortName("d").withLongName("debug").withDescription("print debugging information").create();
        DefaultOption resetOption = obuilder.withShortName("r").withLongName("reset").withDescription("reset user properties to default values").create();
        DefaultOption minimizeOption = obuilder.withShortName("m").withLongName("minim").withDescription("minimize main window on start").create();
        DefaultOption portableOption = obuilder.withShortName("p").withLongName("portable").withDescription("configuration files will be stored in the 'config' folder, all file paths will be saved relatively to FRD folder (if possible) - useful for USB FLASH drives").create();
        DefaultOption noSplashOption = obuilder.withShortName("s").withLongName("nosplash").withDescription("splash screen will be hidden as soon as possible").create();
        PropertyOption propertyOption = new PropertyOption();
        Group options = gbuilder.withName("options").withOption(helpOption).withOption(versionOption).withOption(debugOption).withOption(resetOption).withOption(propertyOption).withOption(minimizeOption).withOption(noSplashOption).withOption(portableOption).create();
        Parser parser = new Parser();
        parser.setGroup(options);
        try {
            CommandLine cmd = parser.parse(args);
            if (cmd.hasOption(helpOption)) {
                this.printHelp(options);
            } else if (cmd.hasOption(versionOption)) {
                this.showVersion();
            } else if (cmd.hasOption(debugOption)) {
                MainApp.debug = true;
            }
            if (cmd.hasOption(resetOption)) {
                this.resetOptions = true;
            }
            if (cmd.hasOption(minimizeOption)) {
                this.minimize = true;
            }
            if (cmd.hasOption(noSplashOption)) {
                this.nosplash = true;
            }
            if (cmd.hasOption(portableOption)) {
                System.getProperties().put("portable", (Object)true);
            }
            Set set = cmd.getProperties(propertyOption);
            for (String o : set) {
                this.properties.put(o, cmd.getProperty(propertyOption, o, ""));
            }
        }
        catch (OptionException e) {
            e.printStackTrace();
            this.printHelp(options);
            System.exit(-1);
        }
        return new LinkedList<String>();
    }

    private void printHelp(Group options) {
        HelpFormatter f = new HelpFormatter();
        f.getDisplaySettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        f.setGroup(options);
        f.setShellCommand("frd");
        f.getLineUsageSettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        f.setFooter("\nmin. Java version required : 1.6");
        f.print();
        this.app.exit();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isResetOptions() {
        return this.resetOptions;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public boolean isNosplash() {
        return this.nosplash;
    }
}

