/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import java.util.HashMap;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.AbstractHttpLogicHandler;
import org.apache.mina.proxy.handlers.http.HttpAuthenticationMethods;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpProxyResponse;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.proxy.utils.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSmartProxyHandler
extends AbstractHttpLogicHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpSmartProxyHandler.class);
    private boolean requestSent = false;
    private AbstractAuthLogicHandler authHandler;

    public HttpSmartProxyHandler(ProxyIoSession proxyIoSession) {
        super(proxyIoSession);
    }

    public void doHandshake(IoFilter.NextFilter nextFilter) throws ProxyAuthException {
        logger.debug(" doHandshake()");
        if (this.authHandler != null) {
            this.authHandler.doHandshake(nextFilter);
        } else {
            if (this.requestSent) {
                throw new ProxyAuthException("Authentication request already sent");
            }
            logger.debug("  sending HTTP request");
            HttpProxyRequest httpProxyRequest = (HttpProxyRequest)this.getProxyIoSession().getRequest();
            HashMap<String, List<String>> hashMap = httpProxyRequest.getHeaders() != null ? httpProxyRequest.getHeaders() : new HashMap<String, List<String>>();
            AbstractAuthLogicHandler.addKeepAliveHeaders(hashMap);
            httpProxyRequest.setHeaders(hashMap);
            this.writeRequest(nextFilter, httpProxyRequest);
            this.requestSent = true;
        }
    }

    private void autoSelectAuthHandler(HttpProxyResponse httpProxyResponse) throws ProxyAuthException {
        List<String> list = httpProxyResponse.getHeaders().get("Proxy-Authenticate");
        ProxyIoSession proxyIoSession = this.getProxyIoSession();
        if (list == null || list.size() == 0) {
            this.authHandler = HttpAuthenticationMethods.NO_AUTH.getNewHandler(proxyIoSession);
        } else if (this.getProxyIoSession().getPreferedOrder() == null) {
            int n = -1;
            for (String string : list) {
                if ((string = string.toLowerCase()).contains("ntlm")) {
                    n = HttpAuthenticationMethods.NTLM.getId();
                    break;
                }
                if (string.contains("digest") && n != HttpAuthenticationMethods.NTLM.getId()) {
                    n = HttpAuthenticationMethods.DIGEST.getId();
                    continue;
                }
                if (!string.contains("basic") || n != -1) continue;
                n = HttpAuthenticationMethods.BASIC.getId();
            }
            if (n != -1) {
                try {
                    this.authHandler = HttpAuthenticationMethods.getNewHandler(n, proxyIoSession);
                }
                catch (Exception exception) {
                    logger.debug("Following exception occured:", (Throwable)exception);
                }
            }
            if (this.authHandler == null) {
                this.authHandler = HttpAuthenticationMethods.NO_AUTH.getNewHandler(proxyIoSession);
            }
        } else {
            block5: for (HttpAuthenticationMethods httpAuthenticationMethods : proxyIoSession.getPreferedOrder()) {
                if (this.authHandler != null) break;
                if (httpAuthenticationMethods == HttpAuthenticationMethods.NO_AUTH) {
                    this.authHandler = HttpAuthenticationMethods.NO_AUTH.getNewHandler(proxyIoSession);
                    break;
                }
                for (String string : list) {
                    string = string.toLowerCase();
                    try {
                        if (string.contains("basic") && httpAuthenticationMethods == HttpAuthenticationMethods.BASIC) {
                            this.authHandler = HttpAuthenticationMethods.BASIC.getNewHandler(proxyIoSession);
                            continue block5;
                        }
                        if (string.contains("digest") && httpAuthenticationMethods == HttpAuthenticationMethods.DIGEST) {
                            this.authHandler = HttpAuthenticationMethods.DIGEST.getNewHandler(proxyIoSession);
                            continue block5;
                        }
                        if (!string.contains("ntlm") || httpAuthenticationMethods != HttpAuthenticationMethods.NTLM) continue;
                        this.authHandler = HttpAuthenticationMethods.NTLM.getNewHandler(proxyIoSession);
                        continue block5;
                    }
                    catch (Exception exception) {
                        logger.debug("Following exception occured:", (Throwable)exception);
                    }
                }
            }
        }
        if (this.authHandler == null) {
            throw new ProxyAuthException("Unknown authentication mechanism(s): " + list);
        }
    }

    public void handleResponse(HttpProxyResponse httpProxyResponse) throws ProxyAuthException {
        if (!this.isHandshakeComplete() && ("close".equalsIgnoreCase(StringUtilities.getSingleValuedHeader(httpProxyResponse.getHeaders(), "Proxy-Connection")) || "close".equalsIgnoreCase(StringUtilities.getSingleValuedHeader(httpProxyResponse.getHeaders(), "Connection")))) {
            this.getProxyIoSession().setReconnectionNeeded(true);
        }
        if (httpProxyResponse.getStatusCode() == 407) {
            if (this.authHandler == null) {
                this.autoSelectAuthHandler(httpProxyResponse);
            }
        } else {
            throw new ProxyAuthException("Error: unexpected response code " + httpProxyResponse.getStatusLine() + " received from proxy.");
        }
        this.authHandler.handleResponse(httpProxyResponse);
    }
}

