/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.mina.core.buffer.AbstractIoBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;

public class SimpleBufferAllocator
implements IoBufferAllocator {
    public IoBuffer allocate(int n, boolean bl) {
        return this.wrap(this.allocateNioBuffer(n, bl));
    }

    public ByteBuffer allocateNioBuffer(int n, boolean bl) {
        ByteBuffer byteBuffer = bl ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        return byteBuffer;
    }

    public IoBuffer wrap(ByteBuffer byteBuffer) {
        return new SimpleBuffer(byteBuffer);
    }

    public void dispose() {
    }

    private class SimpleBuffer
    extends AbstractIoBuffer {
        private ByteBuffer buf;

        protected SimpleBuffer(ByteBuffer byteBuffer) {
            super(SimpleBufferAllocator.this, byteBuffer.capacity());
            this.buf = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        public ByteBuffer buf() {
            return this.buf;
        }

        protected void buf(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }

        public byte[] array() {
            return this.buf.array();
        }

        public int arrayOffset() {
            return this.buf.arrayOffset();
        }

        public boolean hasArray() {
            return this.buf.hasArray();
        }

        public void free() {
        }
    }
}

