/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang.model;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.StandardLocation;
import jlibs.core.annotation.processing.AnnotationError;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.lang.ArrayUtil;
import jlibs.core.lang.NotImplementedException;
import jlibs.core.lang.StringUtil;
import jlibs.core.util.regex.TemplateMatcher;

public class ModelUtil {
    public static String[] primitiveWrappers = new String[]{Boolean.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Character.class.getName(), Float.class.getName(), Double.class.getName()};
    public static String[] primitives = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Character.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName()};
    private static final String PARAM = "@param";
    private static final String RETURN = "@return";

    public static <T> T parent(Element element, Class<T> type) {
        while (!type.isInstance(element = element.getEnclosingElement())) {
        }
        return (T)element;
    }

    public static TypeElement getSuper(TypeElement clazz) {
        TypeMirror superMirror = clazz.getSuperclass();
        if (superMirror instanceof DeclaredType) {
            return (TypeElement)((DeclaredType)superMirror).asElement();
        }
        return null;
    }

    public static String getPackage(Element elem) {
        while (!(elem instanceof PackageElement)) {
            elem = elem.getEnclosingElement();
        }
        return ((PackageElement)elem).getQualifiedName().toString();
    }

    public static boolean isPrimitive(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case ARRAY: 
            case DECLARED: {
                return false;
            }
        }
        return true;
    }

    public static boolean isPrimitiveWrapper(TypeMirror mirror) {
        return mirror.getKind() == TypeKind.DECLARED && ArrayUtil.contains(primitiveWrappers, ModelUtil.toString(mirror, false));
    }

    public static String toString(TypeMirror mirror, boolean usePrimitiveWrappers) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case VOID: {
                return "void";
            }
            case DECLARED: {
                Name paramType = ((TypeElement)((DeclaredType)mirror).asElement()).getQualifiedName();
                List<? extends TypeMirror> typeArguments = ((DeclaredType)mirror).getTypeArguments();
                if (typeArguments.size() == 0) {
                    return paramType.toString();
                }
                StringBuilder buff = new StringBuilder(paramType).append('<');
                for (TypeMirror typeMirror : typeArguments) {
                    buff.append(ModelUtil.toString(typeMirror, false));
                }
                return buff.append('>').toString();
            }
            case INT: {
                return usePrimitiveWrappers ? Integer.class.getName() : kind.toString().toLowerCase();
            }
            case CHAR: {
                return usePrimitiveWrappers ? Character.class.getName() : kind.toString().toLowerCase();
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: 
            case SHORT: 
            case BYTE: {
                String name = kind.toString().toLowerCase();
                return usePrimitiveWrappers ? "java.lang." + StringUtil.capitalize(name) : name;
            }
            case ARRAY: {
                return ModelUtil.toString(((ArrayType)mirror).getComponentType(), false) + "[]";
            }
        }
        throw new NotImplementedException((Object)((Object)kind) + " is not implemented for " + mirror.getClass());
    }

    public static Modifier getModifier(Set<Modifier> set, Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (!set.contains((Object)modifier)) continue;
            return modifier;
        }
        return null;
    }

    public static boolean isAccessible(Element element, boolean samePackage, boolean subClass) {
        Modifier modifier = ModelUtil.getModifier(element.getModifiers(), Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
        if (modifier == null) {
            if (!samePackage) {
                return false;
            }
        } else {
            switch (modifier) {
                case PRIVATE: {
                    return false;
                }
                case PROTECTED: {
                    if (samePackage || subClass) break;
                    return false;
                }
            }
        }
        return true;
    }

    public static String signature(ExecutableElement method, boolean useParamNames) {
        StringBuilder buff = new StringBuilder();
        Set<Modifier> modifiers = method.getModifiers();
        Modifier modifier = ModelUtil.getModifier(modifiers, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
        if (modifier != null) {
            buff.append((Object)modifier).append(' ');
        }
        buff.append(ModelUtil.toString(method.getReturnType(), false));
        buff.append(' ');
        buff.append(method.getSimpleName());
        buff.append('(');
        int i = 0;
        for (VariableElement variableElement : method.getParameters()) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(ModelUtil.toString(variableElement.asType(), false));
            if (useParamNames) {
                buff.append(' ').append(variableElement.getSimpleName());
            }
            ++i;
        }
        buff.append(')');
        List<? extends TypeMirror> throwTypes = method.getThrownTypes();
        if (throwTypes.size() > 0) {
            buff.append(" throws ");
            i = 0;
            for (TypeMirror typeMirror : throwTypes) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(typeMirror);
            }
        }
        return buff.toString();
    }

    public static VariableElement getParameter(ExecutableElement method, String paramName) {
        for (VariableElement variableElement : method.getParameters()) {
            if (!variableElement.getSimpleName().contentEquals(paramName)) continue;
            return variableElement;
        }
        return null;
    }

    public static boolean matches(AnnotationMirror mirror, Class annotation) {
        return ((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotation.getCanonicalName());
    }

    public static AnnotationMirror getAnnotationMirror(Element elem, Class annotation) {
        for (AnnotationMirror annotationMirror : elem.getAnnotationMirrors()) {
            if (!ModelUtil.matches(annotationMirror, annotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static AnnotationValue getRawAnnotationValue(Element pos, AnnotationMirror mirror, String method) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(method)) continue;
            return entry.getValue();
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : Environment.get().getElementUtils().getElementValuesWithDefaults(mirror).entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(method)) continue;
            return entry.getValue();
        }
        throw new AnnotationError(pos, mirror, "annotation " + ((TypeElement)mirror.getAnnotationType().asElement()).getQualifiedName() + " is missing " + method);
    }

    public static <T> T getAnnotationValue(Element pos, AnnotationMirror mirror, String method) {
        return (T)ModelUtil.getRawAnnotationValue(pos, mirror, method).getValue();
    }

    public static <T> T getAnnotationValue(Element elem, Class annotation, String method) {
        AnnotationMirror mirror = ModelUtil.getAnnotationMirror(elem, annotation);
        if (mirror != null) {
            return ModelUtil.getAnnotationValue(elem, mirror, method);
        }
        return null;
    }

    public static String getMethodDoc(String doc) {
        if (doc == null) {
            return null;
        }
        int index = doc.indexOf(PARAM);
        doc = index == -1 ? doc.trim() : doc.substring(0, index).trim();
        index = doc.indexOf(RETURN);
        doc = index == -1 ? doc.trim() : doc.substring(0, index).trim();
        return doc;
    }

    private static String[] split(String str, boolean whitespace) {
        char ch;
        int i;
        for (i = 0; i < str.length() && Character.isWhitespace(ch = str.charAt(i)) == whitespace; ++i) {
        }
        return new String[]{str.substring(0, i), str.substring(i)};
    }

    public static Map<String, String> getMethodParamDocs(String doc) {
        HashMap<String, String> docs = new HashMap<String, String>();
        if (doc != null) {
            int index = doc.indexOf(RETURN);
            if (index != -1) {
                doc = doc.substring(0, index);
            }
            if ((index = doc.indexOf(PARAM)) != -1) {
                doc = doc.substring(index).trim();
            }
            for (String token : doc.split(PARAM)) {
                if ((token = token.trim()).length() <= 0) continue;
                String[] str = ModelUtil.split(token, false);
                str[1] = str[1].trim();
                if (str[0].length() <= 0 || str[1].length() <= 0) continue;
                docs.put(str[0], str[1]);
            }
        }
        return docs;
    }

    public static String[] findClass(TypeElement clazz, String format) {
        String clazzName;
        String pakage;
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("package", ModelUtil.getPackage(clazz));
        vars.put("class", clazz.getSimpleName().toString());
        String qname = new TemplateMatcher("${", "}").replace(format, vars);
        int dot = qname.lastIndexOf(46);
        if (dot == -1) {
            pakage = "";
            clazzName = qname;
        } else {
            pakage = qname.substring(0, dot);
            clazzName = qname.substring(dot + 1);
            if (pakage.length() == 0) {
                qname = clazzName;
            }
        }
        return new String[]{qname, pakage, clazzName};
    }

    public static Class findClass(Class clazz, String format) throws ClassNotFoundException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("package", clazz.getPackage() != null ? clazz.getPackage().getName() : "");
        vars.put("class", clazz.getSimpleName());
        String qname = new TemplateMatcher("${", "}").replace(format, vars);
        if (qname.startsWith(".")) {
            qname = qname.substring(1);
        }
        return clazz.getClassLoader().loadClass(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String pakage, String relativeName) {
        boolean bl;
        block6: {
            InputStream is = null;
            try {
                is = Environment.get().getFiler().getResource(StandardLocation.SOURCE_PATH, pakage, relativeName).openInputStream();
                System.out.println("is: " + is);
                bl = true;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }
}

