/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.ParentImpl;
import org.apache.commons.cli2.resource.ResourceHelper;

public class Switch
extends ParentImpl {
    public static final ResourceHelper resources = ResourceHelper.getResourceHelper();
    public static final String DEFAULT_ENABLED_PREFIX = "+";
    public static final String DEFAULT_DISABLED_PREFIX = "-";
    private final String enabledPrefix;
    private final String disabledPrefix;
    private final Set triggers;
    private final String preferredName;
    private final Set aliases;
    private final Set prefixes;
    private final Boolean defaultSwitch;

    public Switch(String enabledPrefix, String disabledPrefix, String preferredName, Set aliases, String description, boolean required, Argument argument, Group children, int id, Boolean switchDefault) {
        super(argument, children, description, id, required);
        if (enabledPrefix == null) {
            throw new IllegalArgumentException(resources.getMessage("Switch.no.enabledPrefix"));
        }
        if (disabledPrefix == null) {
            throw new IllegalArgumentException(resources.getMessage("Switch.no.disabledPrefix"));
        }
        if (enabledPrefix.startsWith(disabledPrefix)) {
            throw new IllegalArgumentException(resources.getMessage("Switch.enabled.startsWith.disabled"));
        }
        if (disabledPrefix.startsWith(enabledPrefix)) {
            throw new IllegalArgumentException(resources.getMessage("Switch.disabled.startsWith.enabled"));
        }
        this.enabledPrefix = enabledPrefix;
        this.disabledPrefix = disabledPrefix;
        this.preferredName = preferredName;
        if (preferredName == null || preferredName.length() < 1) {
            throw new IllegalArgumentException(resources.getMessage("Switch.preferredName.too.short"));
        }
        HashSet<String> newTriggers = new HashSet<String>();
        newTriggers.add(enabledPrefix + preferredName);
        newTriggers.add(disabledPrefix + preferredName);
        this.triggers = Collections.unmodifiableSet(newTriggers);
        if (aliases == null) {
            this.aliases = Collections.EMPTY_SET;
        } else {
            this.aliases = Collections.unmodifiableSet(new HashSet(aliases));
            for (String alias : aliases) {
                newTriggers.add(enabledPrefix + alias);
                newTriggers.add(disabledPrefix + alias);
            }
        }
        HashSet<String> newPrefixes = new HashSet<String>(super.getPrefixes());
        newPrefixes.add(enabledPrefix);
        newPrefixes.add(disabledPrefix);
        this.prefixes = Collections.unmodifiableSet(newPrefixes);
        this.defaultSwitch = switchDefault;
        this.checkPrefixes(newPrefixes);
    }

    @Override
    public void processParent(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        String arg = (String)arguments.next();
        if (this.canProcess(commandLine, arg)) {
            if (arg.startsWith(this.enabledPrefix)) {
                commandLine.addSwitch(this, true);
                arguments.set(this.enabledPrefix + this.preferredName);
            }
            if (arg.startsWith(this.disabledPrefix)) {
                commandLine.addSwitch(this, false);
                arguments.set(this.disabledPrefix + this.preferredName);
            }
        } else {
            throw new OptionException(this, "Unexpected.token", arg);
        }
    }

    @Override
    public Set getTriggers() {
        return this.triggers;
    }

    @Override
    public Set getPrefixes() {
        return this.prefixes;
    }

    @Override
    public void validate(WriteableCommandLine commandLine) throws OptionException {
        if (this.isRequired() && !commandLine.hasOption(this)) {
            throw new OptionException(this, "Option.missing.required", this.getPreferredName());
        }
        super.validate(commandLine);
    }

    @Override
    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean both;
        boolean optional = !this.isRequired() && helpSettings.contains(DisplaySetting.DISPLAY_OPTIONAL);
        boolean displayAliases = helpSettings.contains(DisplaySetting.DISPLAY_ALIASES);
        boolean disabled = helpSettings.contains(DisplaySetting.DISPLAY_SWITCH_DISABLED);
        boolean enabled = !disabled || helpSettings.contains(DisplaySetting.DISPLAY_SWITCH_ENABLED);
        boolean bl = both = disabled && enabled;
        if (optional) {
            buffer.append('[');
        }
        if (enabled) {
            buffer.append(this.enabledPrefix).append(this.preferredName);
        }
        if (both) {
            buffer.append('|');
        }
        if (disabled) {
            buffer.append(this.disabledPrefix).append(this.preferredName);
        }
        if (displayAliases && !this.aliases.isEmpty()) {
            buffer.append(" (");
            ArrayList list = new ArrayList(this.aliases);
            Collections.sort(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String alias = (String)i.next();
                if (enabled) {
                    buffer.append(this.enabledPrefix).append(alias);
                }
                if (both) {
                    buffer.append('|');
                }
                if (disabled) {
                    buffer.append(this.disabledPrefix).append(alias);
                }
                if (!i.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
        }
        super.appendUsage(buffer, helpSettings, comp);
        if (optional) {
            buffer.append(']');
        }
    }

    @Override
    public String getPreferredName() {
        return this.enabledPrefix + this.preferredName;
    }

    @Override
    public void defaults(WriteableCommandLine commandLine) {
        commandLine.setDefaultSwitch(this, this.defaultSwitch);
    }
}

