/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.RootPaneContainer;

public final class SwingHelper {
    private static final String WINDOW_STATE_NORMAL_BOUNDS = "WindowState.normalBounds";

    private SwingHelper() {
    }

    public static Rectangle computeVirtualGraphicsBounds() {
        GraphicsDevice[] gs;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        return virtualBounds;
    }

    public static boolean isResizable(Window window) {
        boolean resizable = true;
        if (window instanceof Frame) {
            resizable = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            resizable = ((Dialog)window).isResizable();
        }
        return resizable;
    }

    public static Point defaultLocation(Window window) {
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        Rectangle bounds = gc.getBounds();
        Insets insets = window.getToolkit().getScreenInsets(gc);
        int x = bounds.x + insets.left;
        int y = bounds.y + insets.top;
        return new Point(x, y);
    }

    public static RootPaneContainer findRootPaneContainer(Component root) {
        while (root != null) {
            if (root instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)root);
            }
            if (root instanceof JPopupMenu && root.getParent() == null) {
                root = ((JPopupMenu)root).getInvoker();
                continue;
            }
            root = root.getParent();
        }
        return null;
    }

    public static Rectangle getWindowNormalBounds(Window window) {
        Object res;
        if (window instanceof JFrame && (res = ((JFrame)window).getRootPane().getClientProperty(WINDOW_STATE_NORMAL_BOUNDS)) instanceof Rectangle) {
            return (Rectangle)res;
        }
        return null;
    }

    public static void putWindowNormalBounds(Window window, Rectangle bounds) {
        if (window instanceof JFrame) {
            ((JFrame)window).getRootPane().putClientProperty(WINDOW_STATE_NORMAL_BOUNDS, bounds);
        }
    }
}

