/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jdesktop.application.utils.PlatformType;

public final class AppHelper {
    private static PlatformType activePlatformType = null;

    private AppHelper() {
    }

    public static PlatformType getPlatform() {
        if (activePlatformType != null) {
            return activePlatformType;
        }
        activePlatformType = PlatformType.DEFAULT;
        PrivilegedAction<String> doGetOSName = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        };
        String osName = AccessController.doPrivileged(doGetOSName);
        if (osName != null) {
            osName = osName.toLowerCase();
            for (PlatformType platformType : PlatformType.values()) {
                for (String pattern : platformType.getPatterns()) {
                    if (!osName.startsWith(pattern)) continue;
                    activePlatformType = platformType;
                    return activePlatformType;
                }
            }
        }
        activePlatformType = PlatformType.DEFAULT;
        return activePlatformType;
    }
}

