/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.awt.image.BufferedImage;
import java.io.IOException;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;

public abstract class RgbBitmap
extends Bitmap {
    protected int amountOfBytesToRead = 3;

    protected RgbBitmap(IconEntry pEntry, int pAmountOfBytesToRead) throws IOException {
        this(pEntry);
        this.amountOfBytesToRead = pAmountOfBytesToRead;
    }

    protected RgbBitmap(IconEntry pEntry) throws IOException {
        super(pEntry);
    }

    protected BufferedImage createImage() throws IOException {
        int w = this.entry.getHeight();
        int h = this.entry.getWidth();
        int[] pixeldata = new int[h * w];
        for (int rijNr = 0; rijNr < w; ++rijNr) {
            byte[] rij = this.reader.readBytes(h * this.amountOfBytesToRead);
            int rByte = 0;
            int oPos = (w - rijNr - 1) * h;
            for (int colNr = 0; colNr < h; ++colNr) {
                int pos = oPos++;
                pixeldata[pos] = rij[rByte++] & 0xFF;
                if (this.amountOfBytesToRead > 1) {
                    int n = pos;
                    pixeldata[n] = pixeldata[n] + ((rij[rByte++] & 0xFF) << 8);
                } else {
                    int n = pos;
                    pixeldata[n] = pixeldata[n] + 0;
                }
                if (this.amountOfBytesToRead > 2) {
                    int n = pos;
                    pixeldata[n] = pixeldata[n] + ((rij[rByte++] & 0xFF) << 16);
                } else {
                    int n = pos;
                    pixeldata[n] = pixeldata[n] + 0;
                }
                if (this.amountOfBytesToRead > 3) {
                    int n = pos;
                    pixeldata[n] = pixeldata[n] + ((rij[rByte++] & 0xFF) << 24);
                    continue;
                }
                int n = pos;
                pixeldata[n] = pixeldata[n] + -16777216;
            }
        }
        BufferedImage bIm = new BufferedImage(this.entry.getWidth(), this.entry.getHeight(), 2);
        bIm.setRGB(0, 0, h, w, pixeldata, 0, h);
        return bIm;
    }
}

