/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.lib;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import nl.ikarus.nxt.priv.imageio.icoreader.VersionData;
import nl.ikarus.nxt.priv.imageio.icoreader.lib.ICOReader;

public class ICOReaderSpi
extends ImageReaderSpi {
    private static volatile Boolean isRegistered = Boolean.FALSE;

    public ICOReaderSpi() {
        this("nXt webapps", VersionData.getVersion(), new String[]{"ico", "ICO"}, new String[]{"ico", "ICO"}, new String[]{"image/vnd.microsoft.icon", "image/x-ico"}, "nl.ikarus.nxt.priv.imageio.icoreader.lib.ICOReader", new Class[]{ImageInputStream.class}, (String[])null, false, (String)null, (String)null, (String[])null, (String[])null, false, "nl.ikarus.nxt.priv.imageio.icoreader.lib.ICOMetaData_1.0", "nl.ikarus.nxt.priv.imageio.icoreader.lib.ICOMetaData", (String[])null, (String[])null);
    }

    public ICOReaderSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String readerClassName, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (source instanceof ImageInputStream) {
            byte[] buff = new byte[4];
            ImageInputStream in = (ImageInputStream)source;
            in.mark();
            in.readFully(buff);
            in.reset();
            return buff[0] == 0 && buff[1] == 0 && buff[2] == 1 && buff[3] == 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerIcoReader() {
        block5: {
            if (isRegistered.booleanValue()) {
                return;
            }
            isRegistered = Boolean.TRUE;
            try {
                boolean DEBUG;
                Object registeredReader = IIORegistry.getDefaultInstance().getServiceProviderByClass(ICOReaderSpi.class);
                if (registeredReader == null) {
                    ICOReaderSpi reader = new ICOReaderSpi();
                    IIORegistry.getDefaultInstance().registerServiceProvider(reader);
                }
                if (!(DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false))).booleanValue())) break block5;
                System.out.println(ICOReader.class.getName() + " loaded, version: " + VersionData.getVersion() + " build: " + VersionData.getBuild());
            }
            catch (Throwable throwable) {
                boolean DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false)));
                if (DEBUG) {
                    System.out.println(ICOReader.class.getName() + " loaded, version: " + VersionData.getVersion() + " build: " + VersionData.getBuild());
                }
                throw throwable;
            }
        }
    }

    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new ICOReader(this);
    }

    public String getDescription(Locale locale) {
        return "Microsoft Icon Format (ICO) Reader version: " + VersionData.getVersion() + " #" + VersionData.getBuild();
    }

    static {
        ICOReaderSpi.registerIcoReader();
    }
}

