/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogUtils {
    private LogUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLogging(String file) {
        InputStream inputStream = null;
        try {
            inputStream = LogUtils.class.getClassLoader().getResourceAsStream(file);
            if (inputStream == null) {
                throw new IOException("Log properties file was not found: " + file);
            }
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException e1) {
                System.err.println("Loading of the logging properties failed");
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void processException(Logger logger, Throwable e) {
        logger.log(Level.SEVERE, "", e);
    }
}

