/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public abstract class AppDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(AppDialog.class.getName());
    public static final int RESULT_OK = 0;
    static final int RESULT_CANCEL = 1;
    int result = 1;
    private ActionMap actionMap = null;

    public AppDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
    }

    public AppDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
    }

    public void doClose() {
        if (this.actionMap != null) {
            this.actionMap.remove(this);
        }
        this.dispose();
    }

    public final int getModalResult() {
        return this.result;
    }

    protected AbstractButton getBtnCancel() {
        return null;
    }

    protected AbstractButton getBtnOK() {
        return null;
    }

    public MainApp getApp() {
        return MainApp.getInstance(MainApp.class);
    }

    protected void inject() {
        Application application = Application.getInstance(Application.class);
        ApplicationContext context = application.getContext();
        context.getResourceMap(this.getClass()).injectComponents(this);
        this.getContentPane().applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    @Override
    protected final JRootPane createRootPane() {
        ActionListener escapeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppDialog.this.doCancel(actionEvent);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppDialog.this.windowIsClosing();
            }
        });
        ActionListener okButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton button;
                if (AppDialog.this.getFocusOwner() instanceof AbstractButton) {
                    button = (AbstractButton)AppDialog.this.getFocusOwner();
                    if (button instanceof JToggleButton) {
                        JToggleButton toggleButton = (JToggleButton)button;
                        if (!toggleButton.isSelected()) {
                            AppDialog.doButtonAction(button, actionEvent);
                            return;
                        }
                    } else {
                        AppDialog.doButtonAction(button, actionEvent);
                        return;
                    }
                }
                if ((button = AppDialog.this.getBtnOK()) != null) {
                    actionEvent.setSource(button);
                    AppDialog.doButtonAction(button, actionEvent);
                }
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(escapeActionListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 0);
        rootPane.registerKeyboardAction(okButtonListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 2);
        rootPane.registerKeyboardAction(okButtonListener, stroke, 2);
        return rootPane;
    }

    protected void windowIsClosing() {
    }

    private void doCancel(ActionEvent actionEvent) {
        AbstractButton button = this.getBtnCancel();
        if (button != null) {
            AppDialog.doButtonAction(button, actionEvent);
        }
    }

    private static void doButtonAction(AbstractButton button, ActionEvent actionEvent) {
        Action action = button.getAction();
        if (action != null && action.isEnabled()) {
            button.doClick();
        }
    }

    void setResult(int result) {
        this.result = result;
    }

    protected ResourceMap getResourceMap() {
        return Swinger.getResourceMap(this.getClass(), AppDialog.class);
    }

    protected static void locateOnOpticalScreenCenter(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (int)((double)(screenSize.height - paneSize.height) * 0.45));
    }

    protected String[] getList(String key, int valueCount) {
        ResourceMap resourceMap = this.getResourceMap();
        String[] list = new String[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            list[i] = resourceMap.getString(key + "_" + i, new Object[0]);
        }
        return list;
    }

    protected boolean validateNonEmpty(JTextComponent component) {
        String text;
        Document doc = component.getDocument();
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
            return false;
        }
        return this.validateNonEmpty(text);
    }

    protected boolean validateNonEmpty(JTextField field, String value) {
        if (!this.validateNonEmpty(value)) {
            Swinger.inputFocus(field);
            return false;
        }
        return true;
    }

    protected boolean validateNonEmpty(String text) {
        return text.trim().length() > 0;
    }

    protected Action setAction(AbstractButton button, String actionCode) {
        if (button == null) {
            throw new IllegalArgumentException("Button component cannot be null");
        }
        Action action = this.getActionMap().get(actionCode);
        if (action == null) {
            throw new IllegalArgumentException("Action with actionCode " + actionCode + " was not found");
        }
        button.setAction(action);
        Object keystroke = action.getValue("AcceleratorKey");
        if (keystroke != null) {
            this.registerKeyboardAction(action);
            Object desc = action.getValue("ShortDescription");
            if (desc != null) {
                action.putValue("ShortDescription", desc.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)keystroke) + ")");
            }
        }
        return action;
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = Swinger.getActionMap(this.getClass(), this);
            return this.actionMap;
        }
        return this.actionMap;
    }

    protected void setContextHelp(AbstractButton btnHelp, String contextHelp) {
        Action helpAction = this.getActionMap().get("contextDialogHelpAction");
        btnHelp.setAction(helpAction);
        btnHelp.setActionCommand(contextHelp);
        btnHelp.putClientProperty("contextDialogHelp", contextHelp);
        this.rootPane.registerKeyboardAction(helpAction, contextHelp, (KeyStroke)helpAction.getValue("AcceleratorKey"), 2);
    }

    protected void registerKeyboardAction(String action) {
        this.registerKeyboardAction(this.getActionMap().get(action));
    }

    protected void registerKeyboardAction(Action action) {
        this.registerKeyboardAction(action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    protected void registerKeyboardAction(Action action, KeyStroke keystroke) {
        this.rootPane.registerKeyboardAction(action, keystroke, 2);
    }
}

