/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import com.jgoodies.common.collect.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.ExportLinksTask;
import cz.vity.freerapid.core.tasks.ImportLinksTask;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.NewLinksDialog;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenSaveDialogFactory;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;

@ProxyActions(value={"select-all", "copy", "cut", "paste", "delete"})
public class FileActions
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(FileActions.class.getName());
    private static final String ID_CONTAINER = "container";
    private final MainApp app;
    private final PluginsManager pluginsManager;
    private final DataManager dataManager;
    private final TaskServiceManager taskServiceManager;
    private final ContentPanel contentPanel;
    private NewLinksDialog dialog;
    private long restart;
    private boolean restartHookInstalled;

    public FileActions(ApplicationContext context) {
        this.app = (MainApp)context.getApplication();
        this.pluginsManager = this.app.getManagerDirector().getPluginsManager();
        this.dataManager = this.app.getManagerDirector().getDataManager();
        this.taskServiceManager = this.app.getManagerDirector().getTaskServiceManager();
        this.contentPanel = this.app.getManagerDirector().getContentManager().getContentPanel();
        this.restartHookInstalled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void addNewLinksAction(ActionEvent event) {
        boolean showing;
        final ManagerDirector managerDirector = this.app.getManagerDirector();
        List urlList = null;
        boolean bl = showing = this.dialog != null;
        if (event.getSource() instanceof List) {
            urlList = (List)event.getSource();
            if (urlList.isEmpty()) {
                return;
            }
            if (!showing) {
                Object object = this.dataManager.getLock();
                synchronized (object) {
                    ArrayListModel<DownloadFile> files = this.dataManager.getDownloadFiles();
                    int counterFound = 0;
                    for (DownloadFile file : files) {
                        URL urlAddress = file.getFileUrl();
                        if (!urlList.contains(urlAddress)) continue;
                        ++counterFound;
                    }
                    if (counterFound == urlList.size()) {
                        return;
                    }
                }
            }
        }
        if (!showing) {
            this.dialog = new NewLinksDialog(managerDirector, this.app.getMainFrame());
        }
        if (urlList != null) {
            boolean activate = AppPrefs.getProperty("bringToFrontWhenPasted", true);
            if (activate) {
                Swinger.bringToFront(this.app.getMainFrame(), activate);
            } else if (!showing) {
                Swinger.bringToFront(this.app.getMainFrame(), activate);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            final List urlList1 = urlList;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FileActions.this.dialog != null) {
                        FileActions.this.dialog.setURLs(urlList1);
                    } else {
                        logger.warning("Dialog is null");
                    }
                }
            });
        }
        if (!showing) {
            List<DownloadFile> files;
            this.app.prepareDialog(this.dialog, true);
            if (this.dialog.getModalResult() == 0 && !(files = this.dialog.getDownloadFiles()).isEmpty()) {
                this.dataManager.addToList(files);
                final boolean notPaused = !this.dialog.isStartPaused();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (notPaused) {
                            FileActions.this.dataManager.addToQueue(files);
                        }
                        managerDirector.getContentManager().getContentPanel().selectAdded(files);
                    }
                });
            }
            this.dialog = null;
        }
    }

    @Action
    public void restartApplication() {
        this.installShutdownHook();
        this.restart = System.currentTimeMillis();
        this.app.exit();
    }

    private void installShutdownHook() {
        if (this.restartHookInstalled) {
            return;
        }
        final SystemCommander commander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.app.getContext());
        if (!commander.isSupported(OSCommand.RESTART_APPLICATION)) {
            Swinger.showErrorMessage(this.app.getContext().getResourceMap(), "systemCommandNotSupported", OSCommand.RESTART_APPLICATION.toString().toLowerCase());
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - FileActions.this.restart < 4000L) {
                    commander.shutDown(OSCommand.RESTART_APPLICATION, false);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
        this.restartHookInstalled = true;
    }

    @Action
    public void importLinksAction(ActionEvent e) {
        this.importLinks();
    }

    @Action
    public void exportSelectedLinksAction(ActionEvent e) {
        this.exportLinks(this.dataManager.getSelectionToList(this.contentPanel.getSelectedRows()));
    }

    @Action
    public void exportAllLinksAction(ActionEvent e) {
        this.exportLinks(this.dataManager.getActualDownloadFiles());
    }

    public void importLinks() {
        File[] files;
        ContainerPlugin plugin = this.getContainerPlugin();
        if (plugin != null && (files = OpenSaveDialogFactory.getInstance(this.app.getContext()).getImportLinks(plugin.getSupportedFiles())) != null && files.length > 0) {
            ImportLinksTask task = new ImportLinksTask(this.app, plugin, files);
            this.taskServiceManager.runTask("workWithFile", task);
        }
    }

    public void exportLinks(List<DownloadFile> list) {
        File destination;
        ContainerPlugin plugin;
        if (!list.isEmpty() && (plugin = this.getContainerPlugin()) != null && (destination = OpenSaveDialogFactory.getInstance(this.app.getContext()).getExportLinks(plugin.getSupportedFiles())) != null) {
            ExportLinksTask task = new ExportLinksTask(this.app, plugin, list, destination);
            this.taskServiceManager.runTask("workWithFile", task);
        }
    }

    private ContainerPlugin getContainerPlugin() {
        if (!this.pluginsManager.isPluginDisabled(ID_CONTAINER)) {
            try {
                return (ContainerPlugin)this.pluginsManager.getPluginManager().getPlugin(ID_CONTAINER);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
            }
        }
        return null;
    }
}

