/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsComboBoxButtonUI;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.RolloverButtonListener;
import com.pagosoft.plaf.ToolBarButtonUI;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public class PgsButtonUI
extends MetalButtonUI
implements ActionListener {
    private static PgsButtonUI INSTANCE = new PgsButtonUI();
    private Timer defaultButtonTimer = new Timer(50, this);
    private WeakReference defaultButtonRef;
    private int defaultButtonAlpha;
    private boolean defaultButtonAlphaDir;

    public static ComponentUI createUI(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return ToolBarButtonUI.createUI(c);
        }
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.putClientProperty("rolloverBackground", UIManager.getColor("Button.rolloverBackground"));
        b.putClientProperty("pgs.isFlat", UIManager.get("Button.isFlat"));
        b.putClientProperty("gradientStart", UIManager.get("Button.gradientStart"));
        b.putClientProperty("gradientEnd", UIManager.get("Button.gradientEnd"));
        b.putClientProperty("rollover.gradientStart", UIManager.get("Button.rolloverGradientStart"));
        b.putClientProperty("rollover.gradientEnd", UIManager.get("Button.rolloverGradientEnd"));
        b.putClientProperty("selected.gradientStart", UIManager.get("Button.selectedGradientStart"));
        b.putClientProperty("selected.gradientEnd", UIManager.get("Button.selectedGradientEnd"));
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isFocusPainted() && !(b instanceof PgsComboBoxButtonUI)) {
            int topLeftInset = 3;
            int width = b.getWidth() - topLeftInset * 2;
            int height = b.getHeight() - topLeftInset * 2;
            g.setColor(this.getFocusColor());
            PgsUtils.drawRoundRect(g, topLeftInset, topLeftInset, width - 1, height - 1, 3, 3);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        JButton b = (JButton)c;
        if (c.isOpaque() && b.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(c.getClientProperty("pgs.isFlat")) || !b.isEnabled()) {
                g.setColor(c.isEnabled() && b.getModel().isRollover() ? (Color)c.getClientProperty("rolloverBackground") : c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            } else {
                g.setColor(c.isEnabled() && b.getModel().isRollover() ? (Color)c.getClientProperty("rolloverBackground") : c.getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                if (c.isEnabled() && b.getModel().isRollover()) {
                    PgsUtils.drawGradient(g, c, "rollover");
                } else {
                    PgsUtils.drawGradient(g, c);
                }
            }
            if (b.isDefaultButton() && PgsUtils.hasFocus(b.getTopLevelAncestor())) {
                JButton defaultButton = this.defaultButtonRef == null ? null : (JButton)this.defaultButtonRef.get();
                if (b != defaultButton) {
                    if (defaultButton == null) {
                        defaultButton = b;
                        this.defaultButtonRef = new WeakReference<JButton>(b);
                        this.defaultButtonTimer.start();
                    } else {
                        JButton temp = defaultButton;
                        defaultButton = b;
                        this.defaultButtonRef = new WeakReference<JButton>(b);
                        temp.repaint();
                    }
                    this.defaultButtonAlpha = 10;
                    this.defaultButtonAlphaDir = true;
                }
                PgsUtils.drawButtonBorder(g, 1, 1, b.getWidth() - 3, b.getHeight() - 3, PgsUtils.rolloverBorderStroke, ColorUtils.getTranslucentColor(PgsLookAndFeel.getPrimaryControlShadow(), this.defaultButtonAlpha));
            }
        }
        super.paint(g, c);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isOpaque() && b.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(b.getClientProperty("pgs.isFlat"))) {
                g.setColor(this.getSelectColor());
                g.fillRect(0, 0, b.getWidth(), b.getHeight());
            } else {
                PgsUtils.drawGradient(g, b, "selected");
            }
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        PgsUtils.installAntialiasing(g);
        super.paintText(g, c, textRect, text);
        PgsUtils.uninstallAntialiasing(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton defaultButton = (JButton)this.defaultButtonRef.get();
        if (defaultButton == null && this.defaultButtonTimer.isRunning()) {
            this.defaultButtonTimer.stop();
            this.defaultButtonRef = null;
            return;
        }
        this.defaultButtonAlpha += this.defaultButtonAlphaDir ? 10 : -10;
        if (this.defaultButtonAlpha == 200 || this.defaultButtonAlpha == 10) {
            this.defaultButtonAlphaDir = !this.defaultButtonAlphaDir;
        }
        defaultButton.repaint();
    }
}

