/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd;

import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.lang.ArrayUtil;
import jlibs.core.lang.StringUtil;
import jlibs.xml.Namespaces;
import jlibs.xml.sax.XMLDocument;
import org.xml.sax.SAXException;

public class XSDocument
extends Namespaces {
    private XMLDocument xml;

    public XSDocument(XMLDocument xml) {
        this.xml = xml;
    }

    public XSDocument(Result result, boolean omitXMLDeclaration, int indentAmount, String encoding) throws TransformerConfigurationException {
        this.xml = new XMLDocument(result, omitXMLDeclaration, indentAmount, encoding);
    }

    public XMLDocument xml() {
        return this.xml;
    }

    public XSDocument startDocument() throws SAXException {
        this.xml.startDocument();
        return this;
    }

    public XSDocument endDocument() throws SAXException {
        this.xml.endDocument();
        return this;
    }

    public XSDocument startSchema(String targetNamespace) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "schema");
        this.xml.addAttribute("targetNamespace", targetNamespace);
        return this;
    }

    public XSDocument endSchema() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "schema");
        return this;
    }

    public XSDocument addImport(String namespace, String schemaLocation) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "import");
        this.xml.addAttribute("namespace", namespace);
        this.xml.addAttribute("schemaLocation", schemaLocation);
        this.xml.endElement();
        return this;
    }

    public XSDocument addInclude(String schemaLocation) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "include");
        this.xml.addAttribute("schemaLocation", schemaLocation);
        this.xml.endElement();
        return this;
    }

    public XSDocument name(String name) throws SAXException {
        this.xml.addAttribute("name", name);
        return this;
    }

    public XSDocument type(String typeNS, String typeLocalpart) throws SAXException {
        this.xml.addAttribute("type", this.xml.toQName(typeNS, typeLocalpart));
        return this;
    }

    public XSDocument ref(String typeNS, String typeLocalpart) throws SAXException {
        this.xml.addAttribute("ref", this.xml.toQName(typeNS, typeLocalpart));
        return this;
    }

    public void occurs(int minOccurs, int maxOccurs) throws SAXException {
        if (minOccurs != 1) {
            this.xml.addAttribute("minOccurs", String.valueOf(minOccurs));
        }
        if (maxOccurs != 1) {
            this.xml.addAttribute("maxOccurs", maxOccurs == -1 ? "unbounded" : String.valueOf(maxOccurs));
        }
    }

    public XSDocument startElement() throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "element");
        return this;
    }

    public XSDocument endElement() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "element");
        return this;
    }

    public XSDocument constraint(Constraint constraint, String constraintValue) throws SAXException {
        if (constraint != Constraint.NONE) {
            this.xml.addAttribute(constraint.name().toLowerCase(), constraintValue);
        }
        return this;
    }

    public XSDocument required(boolean reqd) throws SAXException {
        this.xml.addAttribute("use", reqd ? "required" : "optional");
        return this;
    }

    public XSDocument startAttribute() throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "attribute");
        return this;
    }

    public XSDocument endAttribute() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "attribute");
        return this;
    }

    public XSDocument startSimpleType() throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        return this;
    }

    public XSDocument endSimpleType() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        return this;
    }

    public XSDocument startCompositor(Compositor compositor) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", compositor.name().toLowerCase());
        return this;
    }

    public XSDocument endCompositor() throws SAXException {
        this.xml.endElement();
        return this;
    }

    public XSDocument startDerivation(Derivation derivation, String baseNS, String baseLocalpart) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", derivation.name().toLowerCase());
        this.xml.addAttribute("base", this.xml.toQName(baseNS, baseLocalpart));
        return this;
    }

    public XSDocument endDerivation() throws SAXException {
        this.xml.endElement();
        return this;
    }

    public XSDocument startComplexType() throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "complexType");
        return this;
    }

    public XSDocument prohibit(Derivation ... derivations) throws SAXException {
        if (derivations.length > 0) {
            boolean prohibitExtension = ArrayUtil.contains((Object[])derivations, (Object)((Object)Derivation.EXTENSION));
            boolean prohibitRestriction = ArrayUtil.contains((Object[])derivations, (Object)((Object)Derivation.RESTRICTION));
            if (prohibitExtension && prohibitRestriction) {
                this.xml.addAttribute("final", "#all");
            } else if (prohibitExtension) {
                this.xml.addAttribute("final", "extension");
            } else if (prohibitRestriction) {
                this.xml.addAttribute("final", "restriction");
            }
        }
        return this;
    }

    public XSDocument endComplexType() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "complexType");
        return this;
    }

    public XSDocument startContent(Content content) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", content == Content.SIMPLE ? "simpleContent" : "complexContent");
        if (content == Content.MIXED) {
            this.xml.addAttribute("mixed", "true");
        }
        return this;
    }

    public XSDocument endContent() throws SAXException {
        this.xml.endElement();
        return this;
    }

    public XSDocument addFacet(Facet facet, String value, boolean fixed) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", facet.toString());
        this.xml.addAttribute("value", value);
        if (fixed) {
            this.xml.addAttribute("fixed", "true");
        }
        this.xml.endElement();
        return this;
    }

    public XSDocument addMultiValueFacet(Facet facet, String ... values) throws SAXException {
        String facetName = facet.toString();
        for (String value : values) {
            this.xml.startElement("http://www.w3.org/2001/XMLSchema", facetName);
            this.xml.addAttribute("value", value);
            this.xml.endElement();
        }
        return this;
    }

    public XSDocument addList(String itemTypeNS, String itemTypeLocalpart) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "list");
        this.xml.addAttribute("itemType", this.xml.toQName(itemTypeNS, itemTypeLocalpart));
        this.xml.endElement();
        return this;
    }

    public XSDocument startUnion(String ... memberParts) throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "union");
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < memberParts.length; i += 2) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(this.xml.toQName(memberParts[i], memberParts[i + 1]));
        }
        if (buff.length() > 0) {
            this.xml.addAttribute("memberTypes", buff.toString());
        }
        this.xml.endElement();
        return this;
    }

    public XSDocument endUnion() throws SAXException {
        this.xml.endElement();
        return this;
    }

    public XSDocument startAnnotation() throws SAXException {
        this.xml.startElement("http://www.w3.org/2001/XMLSchema", "annotation");
        return this;
    }

    public XSDocument addDocumentation(String doc) throws SAXException {
        this.xml.addElement("http://www.w3.org/2001/XMLSchema", "documentation", doc);
        return this;
    }

    public XSDocument endAnnotation() throws SAXException {
        this.xml.endElement("http://www.w3.org/2001/XMLSchema", "annotation");
        return this;
    }

    public static void main(String[] args) throws TransformerConfigurationException, SAXException {
        XSDocument xsd = new XSDocument(new StreamResult(System.out), false, 4, null);
        xsd.startDocument();
        String n1 = "http://www.example.com/N1";
        String n2 = "http://www.example.com/N2";
        xsd.xml().declarePrefix("n1", n1);
        xsd.xml().declarePrefix("n2", n2);
        xsd.startSchema(n1);
        xsd.addImport(n2, "imports/b.xsd");
        xsd.startComplexType().name("MyType");
        xsd.startCompositor(Compositor.SEQUENCE);
        xsd.startElement().ref(n1, "e1").endElement();
        xsd.endCompositor();
        xsd.endComplexType();
        xsd.startElement().name("root").type(n1, "MyType").endElement();
        xsd.endSchema();
        xsd.endDocument();
    }

    static enum Facet {
        NONE,
        WHITE_SPACE,
        LENGTH,
        MIN_LENGTH,
        MAX_LENGTH,
        PATTERN,
        ENUMERATION,
        MAX_INCLUSIVE,
        MAX_EXCLUSIVE,
        MIN_EXCLUSIVE,
        MIN_INCLUSIVE,
        TOTAL_DIGITS,
        FRACTION_DIGITS;


        public String toString() {
            String str = this.name().toLowerCase();
            int underscore = str.indexOf(95);
            if (underscore == -1) {
                return str;
            }
            return str.substring(0, underscore) + StringUtil.capitalize((String)str.substring(underscore + 1));
        }
    }

    static enum Content {
        SIMPLE,
        ELEMENT,
        EMPTY,
        MIXED;

    }

    static enum Derivation {
        EXTENSION,
        RESTRICTION,
        SUBSTITUTION;

    }

    static enum Compositor {
        SEQUENCE,
        ALL,
        CHOICE;

    }

    static enum Constraint {
        DEFAULT,
        FIXED,
        NONE;

    }
}

