/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsTheme;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.ThemeFactory;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PgsLauncher {
    private Color primary;
    private Color secondary;
    private Color text = Color.black;

    private void launch(List arguments) throws Exception {
        String argument;
        Iterator i = arguments.iterator();
        while (i.hasNext() && (argument = (String)i.next()).indexOf("=") != -1) {
            this.applyArgument(argument);
            i.remove();
        }
        if (this.primary != null && this.secondary != null) {
            PgsTheme customTheme = ThemeFactory.createTheme("custom", this.primary, this.secondary, this.text);
            PlafOptions.setCurrentTheme(customTheme);
        }
        PlafOptions.setAsLookAndFeel();
        PlafOptions.updateAllUIs();
        String className = (String)arguments.remove(0);
        String[] mainMethodArgs = arguments.toArray(new String[arguments.size()]);
        Class<?> mainClass = Class.forName(className);
        Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{mainMethodArgs});
    }

    private void applyArgument(String argument) {
        String[] keyAndValue = argument.split("\\=", 2);
        String key = keyAndValue[0];
        String value = keyAndValue[1];
        if (key.equalsIgnoreCase("primary")) {
            this.primary = PgsLauncher.parseColor(value);
        } else if (key.equalsIgnoreCase("secondary")) {
            this.secondary = PgsLauncher.parseColor(value);
        } else if (key.equalsIgnoreCase("text")) {
            this.text = PgsLauncher.parseColor(value);
        } else {
            System.out.println("Unhandled key: \"" + key + "\"");
        }
    }

    private static Color parseColor(String value) {
        if (value.startsWith("#")) {
            value = value.substring(1, value.length());
        } else if (value.startsWith("0x")) {
            value = value.substring(2, value.length());
        }
        return new Color(Integer.parseInt(value, 16));
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: PGSLauncher [primary=<color>] [secondary=<color>] [text=<color>] <mainclass> classargs...");
            System.out.println("\t\t  <color> is in hex format, such as FF0000 for red");
            System.out.println("");
            System.out.println("Examples: PGSLauncher com.mycompany.UserInterface");
            System.out.println("\t\t  PGSLauncher primary=FF0000 secondary=0000FF com.mycompany.UserInterface");
            return;
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        argumentsList.addAll(Arrays.asList(args));
        PgsLauncher launcher = new PgsLauncher();
        launcher.launch(argumentsList);
    }
}

