/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingWorker;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

public class TaskMonitor
extends AbstractBean {
    public static final String PROP_FOREGROUND_TASK = "foregroundTask";
    private final PropertyChangeListener applicationPCL = new ApplicationPCL();
    private final PropertyChangeListener taskServicePCL = new TaskServicePCL();
    private final PropertyChangeListener taskPCL = new TaskPCL();
    private final LinkedList<Task> taskQueue = new LinkedList();
    private boolean autoUpdateForegroundTask = true;
    private Task foregroundTask = null;

    public TaskMonitor(ApplicationContext context) {
        context.addPropertyChangeListener(this.applicationPCL);
        for (TaskService taskService : context.getTaskServices()) {
            taskService.addPropertyChangeListener(this.taskServicePCL);
        }
    }

    public void setForegroundTask(Task foregroundTask) {
        Task newTask;
        Task oldTask = this.foregroundTask;
        if (oldTask != null) {
            oldTask.removePropertyChangeListener(this.taskPCL);
        }
        if ((newTask = (this.foregroundTask = foregroundTask)) != null) {
            newTask.addPropertyChangeListener(this.taskPCL);
        }
        this.firePropertyChange(PROP_FOREGROUND_TASK, oldTask, newTask);
    }

    public Task getForegroundTask() {
        return this.foregroundTask;
    }

    public boolean getAutoUpdateForegroundTask() {
        return this.autoUpdateForegroundTask;
    }

    public void setAutoUpdateForegroundTask(boolean autoUpdateForegroundTask) {
        boolean oldValue = this.autoUpdateForegroundTask;
        this.autoUpdateForegroundTask = autoUpdateForegroundTask;
        this.firePropertyChange("autoUpdateForegroundTask", oldValue, this.autoUpdateForegroundTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> copyTaskQueue() {
        LinkedList<Task> linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<Task>(this.taskQueue);
        }
    }

    public List<Task> getTasks() {
        return this.copyTaskQueue();
    }

    private void updateTasks(List<Task> oldTasks, List<Task> newTasks) {
        boolean tasksChanged = false;
        List<Task> oldTaskQueue = this.copyTaskQueue();
        for (Task oldTask : oldTasks) {
            if (newTasks.contains(oldTask) || !this.taskQueue.remove(oldTask)) continue;
            tasksChanged = true;
        }
        for (Task newTask : newTasks) {
            if (this.taskQueue.contains(newTask)) continue;
            this.taskQueue.addLast(newTask);
            tasksChanged = true;
        }
        Iterator tasks = this.taskQueue.iterator();
        while (tasks.hasNext()) {
            Task task = (Task)tasks.next();
            if (!task.isDone()) continue;
            tasks.remove();
            tasksChanged = true;
        }
        if (tasksChanged) {
            List<Task> newTaskQueue = this.copyTaskQueue();
            this.firePropertyChange("tasks", oldTaskQueue, newTaskQueue);
        }
        if (this.autoUpdateForegroundTask && this.getForegroundTask() == null) {
            this.setForegroundTask(this.taskQueue.isEmpty() ? null : this.taskQueue.getLast());
        }
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        private void fireStateChange(Task task, String propertyName) {
            TaskMonitor.this.firePropertyChange(new PropertyChangeEvent(task, propertyName, false, true));
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Task task = (Task)e.getSource();
            if (task != null && task == TaskMonitor.this.getForegroundTask()) {
                TaskMonitor.this.firePropertyChange(e);
                if ("state".equals(propertyName)) {
                    SwingWorker.StateValue newState = (SwingWorker.StateValue)((Object)e.getNewValue());
                    switch (newState) {
                        case PENDING: {
                            this.fireStateChange(task, "pending");
                            break;
                        }
                        case STARTED: {
                            this.fireStateChange(task, "started");
                            break;
                        }
                        case DONE: {
                            this.fireStateChange(task, "done");
                        }
                    }
                }
                if ("completed".equals(propertyName) && TaskMonitor.this.autoUpdateForegroundTask) {
                    TaskMonitor.this.setForegroundTask(TaskMonitor.this.taskQueue.isEmpty() ? null : (Task)TaskMonitor.this.taskQueue.getLast());
                }
            }
        }
    }

    private class TaskServicePCL
    implements PropertyChangeListener {
        private TaskServicePCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("tasks".equals(propertyName)) {
                List oldList = (List)e.getOldValue();
                List newList = (List)e.getNewValue();
                TaskMonitor.this.updateTasks(oldList, newList);
            }
        }
    }

    private class ApplicationPCL
    implements PropertyChangeListener {
        private ApplicationPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("taskServices".equals(propertyName)) {
                List oldList = (List)e.getOldValue();
                List newList = (List)e.getNewValue();
                for (TaskService oldTaskService : oldList) {
                    oldTaskService.removePropertyChangeListener(TaskMonitor.this.taskServicePCL);
                }
                for (TaskService newTaskService : newList) {
                    newTaskService.addPropertyChangeListener(TaskMonitor.this.taskServicePCL);
                }
            }
        }
    }
}

