/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.TextActions;

public class ActionManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ActionManager.class.getName());
    private final ApplicationContext context;
    private final WeakHashMap<Object, WeakReference<ApplicationActionMap>> actionMaps;
    private ApplicationActionMap globalActionMap = null;

    protected ActionManager(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
        this.actionMaps = new WeakHashMap();
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private ApplicationActionMap createActionMapChain(Class startClass, Class stopClass, Object actionsObject, ResourceMap resourceMap) {
        ArrayList classes = new ArrayList();
        Class c = startClass;
        while (true) {
            classes.add(c);
            if (c.equals(stopClass)) break;
            c = c.getSuperclass();
        }
        Collections.reverse(classes);
        ApplicationContext ctx = this.getContext();
        ApplicationActionMap parent = null;
        for (Class clazz : classes) {
            ApplicationActionMap appAM = new ApplicationActionMap(ctx, clazz, actionsObject, resourceMap);
            appAM.setParent(parent);
            parent = appAM;
        }
        return parent;
    }

    public ApplicationActionMap getActionMap() {
        if (this.globalActionMap == null) {
            ApplicationContext ctx = this.getContext();
            Application appObject = ctx.getApplication();
            Class appClass = ctx.getApplicationClass();
            ResourceMap resourceMap = ctx.getResourceMap();
            this.globalActionMap = this.createActionMapChain(appClass, Application.class, appObject, resourceMap);
            this.initProxyActionSupport();
        }
        return this.globalActionMap;
    }

    private void initProxyActionSupport() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addPropertyChangeListener(new KeyboardFocusPCL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationActionMap getActionMap(Class actionsClass, Object actionsObject, ResourceMap resourceMap) {
        if (actionsClass == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        if (actionsObject == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        if (!actionsClass.isAssignableFrom(actionsObject.getClass())) {
            throw new IllegalArgumentException("actionsObject not instanceof actionsClass");
        }
        WeakHashMap<Object, WeakReference<ApplicationActionMap>> weakHashMap = this.actionMaps;
        synchronized (weakHashMap) {
            ApplicationActionMap classActionMap;
            WeakReference<ApplicationActionMap> ref = this.actionMaps.get(actionsObject);
            ApplicationActionMap applicationActionMap = classActionMap = ref != null ? (ApplicationActionMap)ref.get() : null;
            if (classActionMap == null || classActionMap.getActionsClass() != actionsClass) {
                Class<?> actionsObjectClass = actionsObject.getClass();
                if (resourceMap == null) {
                    resourceMap = this.getContext().getResourceMap(actionsObjectClass, actionsClass);
                }
                ActionMap lastActionMap = classActionMap = this.createActionMapChain(actionsObjectClass, actionsClass, actionsObject, resourceMap);
                while (lastActionMap.getParent() != null) {
                    lastActionMap = lastActionMap.getParent();
                }
                lastActionMap.setParent(this.getActionMap());
                this.actionMaps.put(actionsObject, new WeakReference<ApplicationActionMap>(classActionMap));
            }
            return classActionMap;
        }
    }

    public ApplicationActionMap getActionMap(Class actionsClass, Object actionsObject) {
        return this.getActionMap(actionsClass, actionsObject, null);
    }

    private void updateAllProxyActions(JComponent oldFocusOwner, JComponent newFocusOwner) {
        ActionMap ownerActionMap;
        if (newFocusOwner != null && (ownerActionMap = newFocusOwner.getActionMap()) != null) {
            this.updateProxyActions(this.getActionMap(), ownerActionMap, newFocusOwner);
            for (WeakReference<ApplicationActionMap> appAMRef : this.actionMaps.values()) {
                ApplicationActionMap appAM = (ApplicationActionMap)appAMRef.get();
                if (appAM == null) continue;
                this.updateProxyActions(appAM, ownerActionMap, newFocusOwner);
            }
        }
    }

    private void updateProxyActions(ApplicationActionMap appAM, ActionMap ownerActionMap, JComponent focusOwner) {
        for (ApplicationAction proxyAction : appAM.getProxyActions()) {
            String proxyActionName = proxyAction.getName();
            Action proxy = ownerActionMap.get(proxyActionName);
            if (proxy != null) {
                proxyAction.setProxy(proxy);
                proxyAction.setProxySource(focusOwner);
                continue;
            }
            proxyAction.setProxy(null);
            proxyAction.setProxySource(null);
        }
    }

    private final class KeyboardFocusPCL
    implements PropertyChangeListener {
        private final TextActions textActions;

        KeyboardFocusPCL() {
            this.textActions = new TextActions(ActionManager.this.getContext());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("permanentFocusOwner".equals(e.getPropertyName())) {
                JComponent oldOwner = ActionManager.this.getContext().getFocusOwner();
                Object newValue = e.getNewValue();
                JComponent newOwner = newValue instanceof JComponent ? (JComponent)newValue : null;
                this.textActions.updateFocusOwner(oldOwner, newOwner);
                ActionManager.this.getContext().setFocusOwner(newOwner);
                ActionManager.this.updateAllProxyActions(oldOwner, newOwner);
            }
        }
    }
}

