/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class EnhancedToolbar
extends JButtonBar {
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;

    public EnhancedToolbar() {
        this.init();
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new JXButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(9, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.setGroupSelectionFollowFocus(true);
        this.setCyclic(true);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        this.isCyclic = isCyclic;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean groupSelectionFollowFocus) {
        this.isGroupSelectionFollowFocus = groupSelectionFollowFocus;
    }

    private static ButtonGroup getButtonGroup(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (model instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)model).getGroup();
        }
        return null;
    }

    private class JXButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private JXButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean alternativeFocusMode) {
            this.isAlternativeFocusMode = alternativeFocusMode;
        }

        @Override
        protected boolean accept(Component c) {
            AbstractButton button;
            ButtonGroup group;
            if (!this.isAlternativeFocusMode() && c instanceof AbstractButton && (group = EnhancedToolbar.getButtonGroup(button = (AbstractButton)c)) != null && group.getSelection() != null && !button.isSelected()) {
                return false;
            }
            return super.accept(c);
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component componentAfter = super.getComponentAfter(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentAfter;
            }
            if (EnhancedToolbar.this.isCyclic()) {
                return componentAfter == null ? this.getFirstComponent(aContainer) : componentAfter;
            }
            if (aComponent == this.getLastComponent(aContainer)) {
                return aComponent;
            }
            return componentAfter;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentBefore = super.getComponentBefore(aContainer, aComponent);
            if (!this.isAlternativeFocusMode()) {
                return componentBefore;
            }
            if (EnhancedToolbar.this.isCyclic()) {
                return componentBefore == null ? this.getLastComponent(aContainer) : componentBefore;
            }
            if (aComponent == this.getFirstComponent(aContainer)) {
                return aComponent;
            }
            return componentBefore;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";

        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusTraversalPolicy ftp = EnhancedToolbar.this.getFocusTraversalPolicy();
            if (ftp instanceof JXButtonPanelFocusTraversalPolicy) {
                Component next;
                JXButtonPanelFocusTraversalPolicy xftp = (JXButtonPanelFocusTraversalPolicy)ftp;
                String actionCommand = e.getActionCommand();
                Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                xftp.setAlternativeFocusMode(true);
                if (FORWARD.equals(actionCommand)) {
                    next = xftp.getComponentAfter(EnhancedToolbar.this, fo);
                } else if (BACKWARD.equals(actionCommand)) {
                    next = xftp.getComponentBefore(EnhancedToolbar.this, fo);
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + actionCommand));
                }
                xftp.setAlternativeFocusMode(false);
                if (fo instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)fo;
                    b.getModel().setPressed(false);
                }
                if (next != null && fo instanceof AbstractButton && next instanceof AbstractButton) {
                    AbstractButton nextButton;
                    ButtonGroup group = EnhancedToolbar.getButtonGroup((AbstractButton)fo);
                    if (group != EnhancedToolbar.getButtonGroup(nextButton = (AbstractButton)next)) {
                        return;
                    }
                    if (EnhancedToolbar.this.isGroupSelectionFollowFocus() && group != null && group.getSelection() != null && !nextButton.isSelected()) {
                        nextButton.doClick();
                    }
                    next.requestFocusInWindow();
                }
            }
        }
    }
}

