/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.KunstoffMetalTheme;
import cz.vity.freerapid.swing.LaF;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.swingx.util.OS;

public final class LookAndFeels {
    private static final String DEFAULT_LAF = "com.jtattoo.plaf.aero.AeroLookAndFeel";
    private static final String DEFAULT_THEME = "";
    private static final String KUNSTSTOFF = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private LaF selectedLookAndFeel;
    private static final Logger logger = Logger.getLogger(LookAndFeels.class.getName());
    private static final LookAndFeels instance = new LookAndFeels();
    private static final String AQUA = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
    private ClassLoader classLoader = this.initClassLoader();
    private List<LaF> availableLaFs = null;

    public static LookAndFeels getInstance() {
        return instance;
    }

    private LookAndFeels() {
        String selectedLookAndFeelClassName = AppPrefs.getProperty("lookAndFeel", null);
        String selectedTheme = AppPrefs.getProperty("theme", DEFAULT_THEME);
        if (selectedLookAndFeelClassName == null) {
            String value = Swinger.getResourceMap().getString("Application.lookAndFeelDefault", new Object[0]);
            String s = value == null ? DEFAULT_THEME : value.trim();
            selectedTheme = null;
            selectedLookAndFeelClassName = "system".equals(s) ? UIManager.getSystemLookAndFeelClassName() : (!"default".equals(s) && s != null && !s.isEmpty() ? s : (OS.isMacOSX() ? AQUA : DEFAULT_LAF));
        }
        boolean opaque = AppPrefs.getProperty("lafOpaque", true);
        if (selectedTheme == null && KUNSTSTOFF.equals(selectedLookAndFeelClassName)) {
            selectedTheme = KunstoffMetalTheme.class.getName();
        }
        if (selectedTheme == null) {
            selectedTheme = DEFAULT_THEME;
        }
        this.selectedLookAndFeel = new LaF(selectedLookAndFeelClassName, DEFAULT_THEME, selectedTheme, opaque);
    }

    private ClassLoader initClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (Utils.getAppPath().isEmpty()) {
            return classLoader;
        }
        String path = Utils.addFileSeparator(Utils.getAppPath()) + "lookandfeel";
        logger.info("Loading lookandfeel path " + path);
        File file = new File(path);
        try {
            if (file.exists()) {
                File[] jars = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                int jarsCount = jars.length;
                URL[] urls = new URL[jarsCount];
                boolean isDebug = logger.isLoggable(Level.INFO);
                for (int i = 0; i < jarsCount; ++i) {
                    urls[i] = jars[i].toURI().toURL();
                    if (!isDebug) continue;
                    logger.info("Loading URL with a jar " + urls[i]);
                }
                classLoader = new URLClassLoader(urls, classLoader);
            }
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
        return classLoader;
    }

    public final List<LaF> getAvailableLookAndFeels() {
        if (this.availableLaFs == null) {
            String[] lafs;
            this.availableLaFs = new ArrayList<LaF>();
            Properties properties = Utils.loadProperties("lookandfeels.properties", true);
            String namePostfix = ".name";
            String themePostfix = ".theme";
            String opaquePostfix = ".opaque";
            String alonePostfix = ".alone";
            for (String lafID : lafs = properties.getProperty("lafs", DEFAULT_THEME).split("\\|")) {
                String themeCode;
                String theme;
                String className = properties.getProperty(lafID + ".class");
                if (className == null || this.isPresent(className) == null) continue;
                boolean opaque = "true".equals(properties.getProperty(lafID + ".opaque", "true"));
                int themeCounter = -1;
                String nameLaF = properties.getProperty(lafID + ".name", className);
                if ("true".equals(properties.getProperty(lafID + ".alone", "true"))) {
                    this.availableLaFs.add(new LaF(className, nameLaF, DEFAULT_THEME, opaque));
                }
                while (!(theme = properties.getProperty(themeCode = lafID + ".theme" + ++themeCounter, DEFAULT_THEME)).isEmpty()) {
                    if (this.isPresent(theme) == null) continue;
                    String themeName = nameLaF + " - " + properties.getProperty(themeCode + ".name", " - theme");
                    this.availableLaFs.add(new LaF(className, themeName, theme, opaque));
                }
            }
        }
        return this.availableLaFs;
    }

    public final LaF getSelectedLaF() {
        return this.selectedLookAndFeel;
    }

    public final void storeSelectedLaF(LaF laf) {
        AppPrefs.storeProperty("lookAndFeel", laf.getClassName());
        AppPrefs.storeProperty("lafOpaque", laf.isToolbarOpaque());
        if (!laf.hasThemeClass()) {
            AppPrefs.removeProperty("theme");
        } else {
            AppPrefs.storeProperty("theme", laf.getThemeClass());
        }
        this.selectedLookAndFeel = laf;
        logger.config("LaF " + laf + " has been set. It will be effective on restart.");
    }

    public final void loadLookAndFeelSettings() {
        this.loadLookAndFeel(this.selectedLookAndFeel, false);
    }

    private Class<?> isPresent(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (UnsupportedClassVersionError ex) {
            logger.info("Look and feel class/theme " + className + " cannot be instantied. Probably higher version of the JDK is required.");
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadLookAndFeel(LaF laf, boolean updateTree) {
        String lookAndFeelClassName = laf.getClassName();
        String themeClassName = laf.getThemeClass();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (lookAndFeelClassName.equals(KUNSTSTOFF)) {
                this.initKunststoff();
            } else {
                this.initLaf(lookAndFeelClassName, themeClassName);
            }
        }
        catch (Exception e) {
            logger.warning(lookAndFeelClassName + " was not found. Reason: " + e.getMessage());
            if (!lookAndFeelClassName.equals(KUNSTSTOFF)) {
                if (logger.isLoggable(Level.INFO)) {
                    LogUtils.processException(logger, e);
                }
                try {
                    this.initKunststoff();
                }
                catch (Exception ex) {
                    logger.warning("Kunststoff Look and Feel was not found. Using a default metal theme.");
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (updateTree) {
                JFrame mainFrame = MainApp.getInstance(MainApp.class).getMainFrame();
                LookAndFeels.updateAllUIs();
                UIManager.getLookAndFeel().getDefaults();
                mainFrame.invalidate();
                mainFrame.validate();
                mainFrame.repaint();
            }
        }
        return true;
    }

    private void initKunststoff() throws Exception {
        this.initLafWithTheme(KUNSTSTOFF, new KunstoffMetalTheme());
    }

    private void initLafWithTheme(String lookAndFeelClassName, MetalTheme metalTheme) throws Exception {
        LookAndFeel laf = (LookAndFeel)this.classLoader.loadClass(lookAndFeelClassName).newInstance();
        if (metalTheme != null && laf instanceof MetalLookAndFeel) {
            laf.getClass().getMethod("setCurrentTheme", MetalTheme.class).invoke((Object)laf, metalTheme);
        }
        UIManager.put("ClassLoader", this.classLoader);
        UIManager.setLookAndFeel(laf);
        UIManager.put("ClassLoader", this.classLoader);
        Font font = (Font)UIManager.get("TitledBorder.font");
        if (font != null) {
            UIManager.put("TitledBorder.font", font.deriveFont(1));
        }
    }

    private void initLaf(String lookAndFeelClassName, String themeClassName) throws Exception {
        if (themeClassName != null && !themeClassName.isEmpty()) {
            Class<?> themeClass = this.isPresent(themeClassName);
            if (themeClass != null) {
                Object instanceTheme = themeClass.newInstance();
                if (instanceTheme instanceof MetalTheme) {
                    this.initLafWithTheme(lookAndFeelClassName, (MetalTheme)instanceTheme);
                } else {
                    logger.warning("Theme " + instanceTheme.getClass().getName() + " cannot be set.Theme is not an instance of Metaltheme");
                    this.initLafWithTheme(lookAndFeelClassName, null);
                }
            }
        } else {
            this.initLafWithTheme(lookAndFeelClassName, null);
        }
    }

    private static void updateAllUIs() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LookAndFeels.updateWindowUI(frame);
        }
    }

    public static void updateWindowUI(Window window) {
        Window[] windows;
        try {
            LookAndFeels.updateComponentTreeUI(window);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Window window1 : windows = window.getOwnedWindows()) {
            LookAndFeels.updateWindowUI(window1);
        }
    }

    public static void updateComponentTreeUI(Component c) {
        LookAndFeels.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c) {
        Component[] children = null;
        if (c instanceof JToolBar) {
            children = ((JToolBar)c).getComponents();
            if (children != null) {
                boolean opaque = LookAndFeels.getInstance().getSelectedLaF().isToolbarOpaque();
                for (Component aChildren : children) {
                    LookAndFeels.updateComponentTreeUI0(aChildren);
                    if (!(aChildren instanceof JComponent)) continue;
                    ((JComponent)aChildren).setOpaque(!opaque);
                }
            }
            ((JComponent)c).updateUI();
        } else {
            if (c instanceof JComponent) {
                ((JComponent)c).updateUI();
            }
            if (c instanceof JMenu) {
                children = ((JMenu)c).getMenuComponents();
            } else if (c instanceof Container) {
                children = ((Container)c).getComponents();
            }
            if (children != null) {
                for (Component aChildren : children) {
                    LookAndFeels.updateComponentTreeUI0(aChildren);
                }
            }
        }
    }
}

