/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

public final class LaF {
    private final String className;
    private final String name;
    private String themeClass;
    private boolean toolbarOpaque = true;

    public LaF(String className, String name, String themeClass, boolean toolbarOpaque) {
        if (themeClass == null) {
            throw new IllegalArgumentException("Theme class cannot be null. Must have at least ''");
        }
        this.className = className;
        this.name = name;
        this.themeClass = themeClass;
        this.toolbarOpaque = toolbarOpaque;
    }

    public String getClassName() {
        return this.className;
    }

    public final String getName() {
        return this.name;
    }

    public final String getThemeClass() {
        return this.themeClass;
    }

    public boolean hasThemeClass() {
        return this.themeClass != null && !this.themeClass.isEmpty();
    }

    public final boolean isToolbarOpaque() {
        return this.toolbarOpaque;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LaF laF = (LaF)o;
        return this.className.equals(laF.className) && this.themeClass.equals(laF.themeClass);
    }

    private boolean equals(LaF obj) {
        return this.className.equals(obj.getClassName());
    }

    public final String toString() {
        return this.getName();
    }

    public void setThemeClass(String name) {
        this.themeClass = name;
    }
}

