/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.hoster;

import cz.vity.freerapid.plugins.exceptions.FailedToLoadCaptchaPictureException;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class CaptchaSupport {
    private final HttpDownloadClient client;
    private final DialogSupport dialogSupport;

    public CaptchaSupport(HttpDownloadClient client, DialogSupport dialogSupport) {
        this.client = client;
        this.dialogSupport = dialogSupport;
    }

    public String askForCaptcha(BufferedImage image) throws Exception {
        return this.dialogSupport.askForCaptcha(image);
    }

    public String getCaptcha(String url) throws FailedToLoadCaptchaPictureException {
        try {
            return this.dialogSupport.askForCaptcha(this.getCaptchaImage(url));
        }
        catch (FailedToLoadCaptchaPictureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToLoadCaptchaPictureException(e);
        }
    }

    public BufferedImage getCaptchaImage(String url) throws FailedToLoadCaptchaPictureException {
        try {
            return this.loadCaptcha(this.loadStream(url));
        }
        catch (FailedToLoadCaptchaPictureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToLoadCaptchaPictureException(e);
        }
    }

    private InputStream loadStream(String url) throws IOException, FailedToLoadCaptchaPictureException {
        InputStream stream = this.client.makeRequestForFile(this.client.getGetMethod(url));
        if (stream == null) {
            throw new FailedToLoadCaptchaPictureException();
        }
        return stream;
    }

    public BufferedImage loadCaptcha(InputStream inputStream) throws FailedToLoadCaptchaPictureException {
        if (inputStream == null) {
            throw new NullPointerException("InputStreamForCaptchaIsNull");
        }
        try {
            return ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new FailedToLoadCaptchaPictureException("ReadingCaptchaPictureFailed", e);
        }
    }
}

