/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.userprefs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.SpinnerAdapterFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.CellConstraints;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.binding.MyPreferencesAdapter;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.application.ResourceMap;

public abstract class UserPreferencesTab
extends JPanel {
    protected final UserPreferencesDialog dialog;
    protected final ResourceMap resourceMap;
    protected final ActionMap actionMap;
    protected boolean initialized = false;

    protected UserPreferencesTab(UserPreferencesDialog dialog) {
        this.dialog = dialog;
        this.resourceMap = dialog.getResourceMap();
        this.actionMap = dialog.getApp().getContext().getActionManager().getActionMap(this.getClass(), this, dialog.getResourceMap());
    }

    public abstract void build(CellConstraints var1);

    public abstract void init();

    public boolean validated() {
        return true;
    }

    public void apply() {
    }

    public void cancel() {
    }

    protected Action setAction(AbstractButton button, String actionCode) {
        if (button == null) {
            throw new IllegalArgumentException("Button component cannot be null");
        }
        Action action = this.actionMap.get(actionCode);
        if (action == null) {
            throw new IllegalArgumentException("Action with actionCode " + actionCode + " was not found");
        }
        button.setAction(action);
        Object keystroke = action.getValue("AcceleratorKey");
        if (keystroke != null) {
            this.dialog.registerKeyboardAction(action);
            Object desc = action.getValue("ShortDescription");
            if (desc != null) {
                action.putValue("ShortDescription", desc.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)keystroke) + ")");
            }
        }
        return action;
    }

    protected void bindCombobox(JComboBox combobox, String key, Object defaultValue, String resourceKey, int valueCount) {
        String[] stringList = this.dialog.getList(resourceKey, valueCount);
        this.bindCombobox(combobox, key, defaultValue, stringList);
    }

    protected void bindCombobox(JComboBox combobox, String key, Object defaultValue, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("List of combobox values cannot be null!!");
        }
        MyPreferencesAdapter adapter = new MyPreferencesAdapter(key, defaultValue);
        SelectionInList<String> inList = new SelectionInList<String>(values, (ValueModel)new ValueHolder(values[(Integer)adapter.getValue()]), (ValueModel)adapter);
        Bindings.bind(combobox, inList);
    }

    protected void bind(JSpinner spinner, String key, int defaultValue, int minValue, int maxValue, int step) {
        this.bind(spinner, defaultValue, minValue, maxValue, step, this.dialog.getModel().getBufferedPreferences(key, defaultValue));
    }

    protected void bind(JSpinner spinner, int defaultValue, int minValue, int maxValue, int step, ValueModel valueModel) {
        spinner.setModel(SpinnerAdapterFactory.createNumberAdapter(valueModel, defaultValue, minValue, maxValue, step));
        JComponent editor = spinner.getEditor();
        if (editor instanceof JFormattedTextField) {
            JFormattedTextField field = (JFormattedTextField)editor;
            field.setFocusLostBehavior(0);
        }
    }

    protected ValueModel bind(JCheckBox checkBox, String key, Object defaultValue) {
        ValueModel valueModel = this.dialog.getModel().getBufferedPreferences(key, defaultValue);
        return this.bind(checkBox, valueModel);
    }

    protected ValueModel bind(JCheckBox checkBox, ValueModel valueModel) {
        Bindings.bind(checkBox, valueModel);
        return valueModel;
    }

    protected void bind(JTextField field, String key, Object defaultValue) {
        Bindings.bind(field, this.dialog.getModel().getBufferedPreferences(key, defaultValue), false);
    }

    protected void bind(JComboBox combobox, String key, Object defaultValue, String resourceKey, int valueCount) {
        String[] stringList = this.dialog.getList(resourceKey, valueCount);
        this.bind(combobox, key, defaultValue, stringList);
    }

    protected void bind(JComboBox combobox, String key, Object defaultValue, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("List of combobox values cannot be null!!");
        }
        MyPreferencesAdapter adapter = new MyPreferencesAdapter(key, defaultValue);
        SelectionInList<String> inList = new SelectionInList<String>(values, (ValueModel)new ValueHolder(values[(Integer)adapter.getValue()]), (ValueModel)this.dialog.getModel().getBufferedModel(adapter));
        Bindings.bind(combobox, inList);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

