/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.gui.dialogs.filechooser.IFileType;
import cz.vity.freerapid.gui.dialogs.filechooser.JAppFileChooser;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import javax.swing.filechooser.FileFilter;

final class EnhancedFileFilter
extends FileFilter
implements IFileType {
    private final Object[] extensions;
    private final String description;

    public static EnhancedFileFilter createAllFilesFilter() {
        return new EnhancedFileFilter(new String[0], "allFiles", new Object[0]);
    }

    public EnhancedFileFilter(String[] extensions, String labelDescription, Object ... additionalParams) {
        this.extensions = extensions;
        StringBuilder buffer = new StringBuilder();
        int length = extensions.length;
        for (int i = 0; i < length; ++i) {
            buffer.append("*.").append(extensions[i]);
            if (i + 1 == length) continue;
            buffer.append(',');
        }
        if (extensions.length == 0) {
            buffer.append("*.*");
        }
        Object[] params = new Object[additionalParams.length + 1];
        params[0] = buffer.toString();
        System.arraycopy(additionalParams, 0, params, 1, additionalParams.length);
        this.description = Swinger.getResourceMap(JAppFileChooser.class).getString(labelDescription, params);
    }

    @Override
    public final String getExtension() {
        return this.extensions[0].toString();
    }

    @Override
    public final boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (this.extensions.length == 0) {
            return true;
        }
        String extension = Utils.getExtension(f);
        if (extension != null) {
            for (Object ext : this.extensions) {
                if (!extension.equals(ext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }
}

