/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckForNewVersionTask;
import cz.vity.freerapid.gui.dialogs.AboutDialog;
import cz.vity.freerapid.gui.managers.UpdateManager;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogFileHandler;
import cz.vity.freerapid.utilities.OSDesktop;
import java.awt.event.ActionEvent;
import org.jdesktop.application.Action;

public class HelpActions {
    public static final String CONTEXT_DIALOG_HELPPROPERTY = "contextDialogHelp";
    public static final String CONTEXT_DIALOG_HELP_ACTION = "contextDialogHelpAction";
    private MainApp app = MainApp.getInstance(MainApp.class);

    @Action
    public void paypalSupportAction() {
        Browser.openBrowser(AppPrefs.getProperty("paypal", "http://vity.cz/freerapid/paypal"));
    }

    @Action
    public void help() {
        Browser.openBrowser(AppPrefs.getProperty("HELP_URL", "http://wordrider.net/freerapid/help"));
    }

    @Action
    public void checkForNewVersion() {
        this.app.getContext().getTaskService().execute(new CheckForNewVersionTask(true));
    }

    @Action
    public void visitHomepage() {
        Browser.showHomepage();
    }

    @Action
    public void visitForum() {
        Browser.openBrowser("http://wordrider.net/forum/index/9");
    }

    @Action
    public void checkPluginStatuses() {
        Browser.openBrowser(AppPrefs.getProperty("pluginsStatusUrl", "http://wordrider.net/freerapid/plugins.html"));
    }

    @Action
    public void showDemo() {
        Browser.openBrowser(AppPrefs.getProperty("demoURL", "http://wordrider.net/freerapid/demo"));
    }

    @Action
    public void contextDialogHelpAction(ActionEvent event) {
        String context = event.getActionCommand();
        Browser.openBrowser(context);
    }

    @Action
    public void about() {
        AboutDialog aboutDialog = new AboutDialog(this.app.getMainFrame());
        this.app.prepareDialog(aboutDialog, true);
    }

    @Action
    public void checkForNewPlugins() {
        UpdateManager updateManager = this.app.getManagerDirector().getUpdateManager();
        updateManager.checkUpdate(false);
    }

    @Action
    public void czoSupportAction() {
        Browser.openBrowser("http://cos.root.cz/hlasovani/");
    }

    @Action
    public void openLogFile() {
        OSDesktop.openFile(LogFileHandler.getLogFile());
    }

    @Action
    public void browseToLogFile() {
        OSDesktop.openDirectoryForFile(LogFileHandler.getLogFile());
    }
}

