/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public final class MemoryCacheSeekableStream
extends SeekableStream {
    private InputStream src;
    private long pointer = 0L;
    private static final int SECTOR_SHIFT = 9;
    private static final int SECTOR_SIZE = 512;
    private static final int SECTOR_MASK = 511;
    private Vector data = new Vector();
    int sectors = 0;
    int length = 0;
    boolean foundEOS = false;

    public MemoryCacheSeekableStream(InputStream inputStream) {
        this.src = inputStream;
    }

    public final int available() throws IOException {
        return this.src.available();
    }

    private long readUntil(long l) throws IOException {
        int n;
        if (l < (long)this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int n2 = (int)(l >> 9);
        for (int i = n = this.length >> 9; i <= n2; ++i) {
            byte[] byArray = new byte[512];
            this.data.addElement(byArray);
            int n3 = 512;
            int n4 = 0;
            while (n3 > 0) {
                int n5 = this.src.read(byArray, n4, n3);
                if (n5 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                n4 += n5;
                n3 -= n5;
                this.length += n5;
            }
        }
        return this.length;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException(JaiI18N.getString("MemoryCacheSeekableStream0"));
        }
        this.pointer = l;
    }

    public int read() throws IOException {
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            byte[] byArray = (byte[])this.data.elementAt((int)(this.pointer >> 9));
            return byArray[(int)(this.pointer++ & 0x1FFL)] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if (l <= this.pointer) {
            return -1;
        }
        byte[] byArray2 = (byte[])this.data.elementAt((int)(this.pointer >> 9));
        int n3 = Math.min((int)(l < this.pointer + (long)n2 ? l - this.pointer : (long)n2), 512 - (int)(this.pointer & 0x1FFL));
        System.arraycopy(byArray2, (int)(this.pointer & 0x1FFL), byArray, n, n3);
        this.pointer += (long)n3;
        return n3;
    }
}

