/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.MatchingRule;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ManifestParser;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginRegistryImpl
implements PluginRegistry {
    static final String PACKAGE_NAME = "org.java.plugin.registry.xml";
    private static final char UNIQUE_SEPARATOR = '@';
    private static final Log log = LogFactory.getLog(PluginRegistryImpl.class);
    private final List<IntegrityCheckReport.ReportItem> registrationReport = new LinkedList<IntegrityCheckReport.ReportItem>();
    private final Map<String, PluginDescriptor> registeredPlugins = new HashMap<String, PluginDescriptor>();
    private final Map<String, PluginFragment> registeredFragments = new HashMap<String, PluginFragment>();
    private final List<PluginRegistry.RegistryChangeListener> listeners = Collections.synchronizedList(new LinkedList());
    private ManifestParser manifestParser;
    private boolean stopOnError = false;

    public PluginRegistryImpl() {
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registryStart", null));
    }

    @Override
    public void configure(ExtendedProperties config) {
        this.stopOnError = "true".equalsIgnoreCase(config.getProperty("stopOnError", "false"));
        boolean isValidating = !"false".equalsIgnoreCase(config.getProperty("isValidating", "true"));
        this.manifestParser = new ManifestParser(isValidating);
        log.info((Object)("configured, stopOnError=" + this.stopOnError + ", isValidating=" + isValidating));
    }

    @Override
    public ManifestInfo readManifestInfo(URL url) throws ManifestProcessingException {
        try {
            return new ManifestInfoImpl(this.manifestParser.parseManifestInfo(url));
        }
        catch (Exception e) {
            throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", url, e);
        }
    }

    @Override
    public Map<String, Identity> register(URL[] manifests) throws ManifestProcessingException {
        LinkedList<ExtensionPoint> registeredPoints = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> registeredExtensions = new HashMap<String, Extension>();
        for (PluginDescriptor descriptor : this.registeredPlugins.values()) {
            for (ExtensionPoint point : descriptor.getExtensionPoints()) {
                registeredPoints.add(point);
                for (Extension ext : point.getConnectedExtensions()) {
                    registeredExtensions.put(ext.getUniqueId(), ext);
                }
            }
        }
        HashMap<String, Identity> result = new HashMap<String, Identity>(manifests.length);
        HashMap<String, ModelPluginManifest> plugins = new HashMap<String, ModelPluginManifest>();
        HashMap<String, ModelPluginManifest> fragments = new HashMap<String, ModelPluginManifest>();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "manifestsParsingStart", null));
        for (URL url : manifests) {
            ModelPluginManifest model;
            try {
                model = this.manifestParser.parseManifest(url);
            }
            catch (Exception e) {
                log.error((Object)("can't parse manifest file " + url), (Throwable)e);
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", url, e);
                }
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "manifestParsingError", new Object[]{url, e}));
                continue;
            }
            if (model instanceof ModelPluginFragment) {
                fragments.put(url.toExternalForm(), model);
                continue;
            }
            if (!(model instanceof ModelPluginDescriptor)) {
                log.warn((Object)("URL " + url + " points to XML document of unknown type"));
                continue;
            }
            plugins.put(url.toExternalForm(), model);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("manifest files parsed, plugins.size=" + plugins.size() + ", fragments.size=" + fragments.size()));
        }
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "manifestsParsingFinish", new Object[]{plugins.size(), fragments.size()}));
        this.checkVersions(plugins);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-ins versions checked, plugins.size=" + plugins.size()));
        }
        this.checkVersions(fragments);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-in fragments versions checked, fragments.size=" + fragments.size()));
        }
        RegistryChangeDataImpl registryChangeData = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringPluginsStart", null));
        for (ModelPluginManifest model : plugins.values()) {
            PluginDescriptor descr = this.registerPlugin((ModelPluginDescriptor)model, registryChangeData);
            if (descr == null) continue;
            result.put(descr.getLocation().toExternalForm(), descr);
        }
        plugins.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringFragmentsStart", null));
        for (ModelPluginManifest entry : fragments.values()) {
            PluginFragment fragment = this.registerFragment((ModelPluginFragment)entry, registryChangeData);
            if (fragment == null) continue;
            result.put(fragment.getLocation().toExternalForm(), fragment);
        }
        fragments.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringPluginsFinish", this.registeredPlugins.size()));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "registeringFragmentsFinish", this.registeredFragments.size()));
        log.info((Object)("plug-in and fragment descriptors registered - " + result.size()));
        this.dump();
        if (result.isEmpty()) {
            return result;
        }
        for (ExtensionPoint extensionPoint : registeredPoints) {
            ((ExtensionPointImpl)extensionPoint).registryChanged();
        }
        for (Extension extension : registeredExtensions.values()) {
            ((ExtensionImpl)extension).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            for (PluginDescriptor pluginDescriptor : this.registeredPlugins.values()) {
                for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
                    for (Extension ext : extensionPoint.getConnectedExtensions()) {
                        if (!registeredExtensions.containsKey(ext.getUniqueId())) {
                            registryChangeData.putAddedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
                            continue;
                        }
                        registeredExtensions.remove(ext.getUniqueId());
                        if (!registryChangeData.modifiedPlugins().contains(ext.getDeclaringPluginDescriptor().getId()) && !registryChangeData.modifiedPlugins().contains(ext.getExtendedPluginId())) continue;
                        registryChangeData.putModifiedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
                    }
                }
            }
            for (Extension ext : registeredExtensions.values()) {
                registryChangeData.putRemovedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
            }
            this.fireEvent(registryChangeData);
        }
        return result;
    }

    private void checkVersions(Map<String, ModelPluginManifest> plugins) throws ManifestProcessingException {
        HashMap<String, Object[]> versions = new HashMap<String, Object[]>();
        HashSet<String> toBeRemovedUrls = new HashSet<String>();
        Iterator<Map.Entry<String, ModelPluginManifest>> it = plugins.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ModelPluginManifest> entry = it.next();
            String url = entry.getKey();
            ModelPluginManifest model = entry.getValue();
            if (this.registeredPlugins.containsKey(model.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePlugin", model.getId());
                }
                it.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "duplicatedPluginId", model.getId()));
                continue;
            }
            if (this.registeredFragments.containsKey(model.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePluginFragment", model.getId());
                }
                it.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "duplicatedFragmentId", model.getId()));
                continue;
            }
            Object[] version = (Object[])versions.get(model.getId());
            if (version == null) {
                versions.put(model.getId(), new Object[]{model.getVersion(), url});
                continue;
            }
            if (((Version)version[0]).compareTo(model.getVersion()) < 0) {
                toBeRemovedUrls.add((String)version[1]);
                versions.put(model.getId(), new Object[]{model.getVersion(), url});
                continue;
            }
            toBeRemovedUrls.add(url);
        }
        versions.clear();
        for (String url : toBeRemovedUrls) {
            plugins.remove(url);
        }
        toBeRemovedUrls.clear();
    }

    private PluginDescriptor registerPlugin(ModelPluginDescriptor model, RegistryChangeDataImpl registryChangeData) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in, URL - " + model.getLocation()));
        }
        PluginDescriptorImpl result = null;
        try {
            result = new PluginDescriptorImpl(this, model);
            registryChangeData.addedPlugins().add(result.getId());
            for (PluginFragment pluginFragment : this.registeredFragments.values()) {
                PluginFragmentImpl fragment = (PluginFragmentImpl)pluginFragment;
                if (!fragment.matches(result)) continue;
                result.registerFragment(fragment);
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginRegistered", result.getUniqueId()));
        }
        catch (ManifestProcessingException mpe) {
            log.error((Object)("failed registering plug-in, URL - " + model.getLocation()), (Throwable)mpe);
            if (this.stopOnError) {
                throw mpe;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "pluginRegistrationFailed", new Object[]{model.getLocation(), mpe}));
            return null;
        }
        this.registeredPlugins.put(result.getId(), result);
        return result;
    }

    private PluginFragment registerFragment(ModelPluginFragment model, RegistryChangeDataImpl registryChangeData) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in fragment descriptor, URL - " + model.getLocation()));
        }
        PluginFragmentImpl result = null;
        try {
            result = new PluginFragmentImpl(this, model);
            boolean isRegistered = false;
            PluginDescriptorImpl descr = (PluginDescriptorImpl)this.getPluginDescriptor(result.getPluginId());
            if (result.matches(descr)) {
                descr.registerFragment(result);
                if (!registryChangeData.addedPlugins().contains(descr.getId())) {
                    registryChangeData.modifiedPlugins().add(descr.getId());
                }
                isRegistered = true;
            }
            if (!isRegistered) {
                log.warn((Object)("no matching plug-ins found for fragment " + result.getUniqueId()));
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.WARNING, null, IntegrityCheckReport.Error.NO_ERROR, "noMatchingPluginFound", result.getUniqueId()));
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "fragmentRegistered", result.getUniqueId()));
        }
        catch (ManifestProcessingException mpe) {
            log.error((Object)("failed registering plug-in fragment descriptor, URL - " + model.getLocation()), (Throwable)mpe);
            if (this.stopOnError) {
                throw mpe;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.MANIFEST_PROCESSING_FAILED, "fragmentRegistrationFailed", new Object[]{model.getLocation(), mpe}));
            return null;
        }
        this.registeredFragments.put(result.getId(), result);
        return result;
    }

    @Override
    public Collection<String> unregister(String[] ids) {
        LinkedList<ExtensionPoint> registeredPoints = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> registeredExtensions = new HashMap<String, Extension>();
        for (PluginDescriptor pluginDescriptor : this.registeredPlugins.values()) {
            for (ExtensionPoint point : pluginDescriptor.getExtensionPoints()) {
                registeredPoints.add(point);
                for (Extension ext : point.getConnectedExtensions()) {
                    registeredExtensions.put(ext.getUniqueId(), ext);
                }
            }
        }
        HashSet<String> result = new HashSet<String>();
        RegistryChangeDataImpl registryChangeData = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPrepare", null));
        HashMap<String, PluginDescriptor> removingPlugins = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginFragment> removingFragments = new HashMap<String, PluginFragment>();
        for (String element : ids) {
            PluginDescriptor descr = this.registeredPlugins.get(element);
            if (descr != null) {
                for (PluginDescriptor depDescr : this.getDependingPlugins(descr)) {
                    removingPlugins.put(depDescr.getId(), depDescr);
                    registryChangeData.removedPlugins().add(depDescr.getId());
                }
                removingPlugins.put(descr.getId(), descr);
                registryChangeData.removedPlugins().add(descr.getId());
                continue;
            }
            PluginFragment fragment = this.registeredFragments.get(element);
            if (fragment != null) {
                removingFragments.put(fragment.getId(), fragment);
                continue;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.WARNING, null, IntegrityCheckReport.Error.NO_ERROR, "pluginToUngregisterNotFound", element));
        }
        for (PluginDescriptor descr : removingPlugins.values()) {
            for (PluginFragment fragment : descr.getFragments()) {
                if (removingFragments.containsKey(fragment.getId())) continue;
                removingFragments.put(fragment.getId(), fragment);
            }
        }
        this.fireEvent(registryChangeData);
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringFragmentsStart", null));
        for (PluginFragment pluginFragment : removingFragments.values()) {
            PluginFragmentImpl fragment = (PluginFragmentImpl)pluginFragment;
            this.unregisterFragment(fragment);
            if (!removingPlugins.containsKey(fragment.getPluginId())) {
                registryChangeData.modifiedPlugins().add(fragment.getPluginId());
            }
            result.add(fragment.getUniqueId());
        }
        removingFragments.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPluginsStart", null));
        for (PluginDescriptor pluginDescriptor : removingPlugins.values()) {
            PluginDescriptorImpl descr = (PluginDescriptorImpl)pluginDescriptor;
            this.unregisterPlugin(descr);
            result.add(descr.getUniqueId());
        }
        removingPlugins.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringPluginsFinish", this.registeredPlugins.size()));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "unregisteringFragmentsFinish", this.registeredFragments.size()));
        log.info((Object)("plug-in and fragment descriptors unregistered - " + result.size()));
        this.dump();
        if (result.isEmpty()) {
            return result;
        }
        for (ExtensionPoint extensionPoint : registeredPoints) {
            ((ExtensionPointImpl)extensionPoint).registryChanged();
        }
        for (Extension extension : registeredExtensions.values()) {
            ((ExtensionImpl)extension).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            for (PluginDescriptor descriptor : this.registeredPlugins.values()) {
                for (ExtensionPoint point : descriptor.getExtensionPoints()) {
                    for (Extension ext : point.getConnectedExtensions()) {
                        if (!registeredExtensions.containsKey(ext.getUniqueId())) {
                            registryChangeData.putAddedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
                            continue;
                        }
                        registeredExtensions.remove(ext.getUniqueId());
                        if (!registryChangeData.modifiedPlugins().contains(ext.getDeclaringPluginDescriptor().getId()) && !registryChangeData.modifiedPlugins().contains(ext.getExtendedPluginId())) continue;
                        registryChangeData.putModifiedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
                    }
                }
            }
            for (Extension ext : registeredExtensions.values()) {
                registryChangeData.putRemovedExtension(ext.getUniqueId(), this.makeUniqueId(ext.getExtendedPluginId(), ext.getExtendedPointId()));
            }
            this.fireEvent(registryChangeData);
        }
        return result;
    }

    private void unregisterPlugin(PluginDescriptorImpl descr) {
        this.registeredPlugins.remove(descr.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginUnregistered", descr.getUniqueId()));
    }

    private void unregisterFragment(PluginFragmentImpl fragment) {
        PluginDescriptorImpl descr = (PluginDescriptorImpl)this.registeredPlugins.get(fragment.getPluginId());
        if (descr != null) {
            descr.unregisterFragment(fragment);
        }
        this.registeredFragments.remove(fragment.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "fragmentUnregistered", fragment.getUniqueId()));
    }

    private void dump() {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("PLUG-IN REGISTRY DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tPlug-ins: " + this.registeredPlugins.size() + "\r\n");
        for (PluginDescriptor descriptor : this.registeredPlugins.values()) {
            buf.append("\t\t").append(descriptor).append("\r\n");
        }
        buf.append("\tFragments: " + this.registeredFragments.size() + "\r\n");
        for (PluginFragment fragment : this.registeredFragments.values()) {
            buf.append("\t\t").append(fragment).append("\r\n");
        }
        buf.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        buf.append("-------------- DUMP END -----------------\r\n");
        log.debug((Object)buf.toString());
    }

    @Override
    public ExtensionPoint getExtensionPoint(String pluginId, String pointId) {
        PluginDescriptor descriptor = this.registeredPlugins.get(pluginId);
        if (descriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID " + pluginId + " provided for extension point " + pointId);
        }
        for (ExtensionPoint point : descriptor.getExtensionPoints()) {
            if (!point.getId().equals(pointId)) continue;
            if (point.isValid()) {
                return point;
            }
            log.warn((Object)("extension point " + point.getUniqueId() + " is invalid and ignored by registry"));
            break;
        }
        throw new IllegalArgumentException("unknown extension point ID - " + this.makeUniqueId(pluginId, pointId));
    }

    @Override
    public ExtensionPoint getExtensionPoint(String uniqueId) {
        return this.getExtensionPoint(this.extractPluginId(uniqueId), this.extractId(uniqueId));
    }

    @Override
    public boolean isExtensionPointAvailable(String pluginId, String pointId) {
        PluginDescriptor descriptor = this.registeredPlugins.get(pluginId);
        if (descriptor == null) {
            return false;
        }
        for (ExtensionPoint point : descriptor.getExtensionPoints()) {
            if (!point.getId().equals(pointId)) continue;
            return point.isValid();
        }
        return false;
    }

    @Override
    public boolean isExtensionPointAvailable(String uniqueId) {
        return this.isExtensionPointAvailable(this.extractPluginId(uniqueId), this.extractId(uniqueId));
    }

    @Override
    public PluginDescriptor getPluginDescriptor(String pluginId) {
        PluginDescriptor result = this.registeredPlugins.get(pluginId);
        if (result == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + pluginId);
        }
        return result;
    }

    @Override
    public boolean isPluginDescriptorAvailable(String pluginId) {
        return this.registeredPlugins.containsKey(pluginId);
    }

    @Override
    public Collection<PluginDescriptor> getPluginDescriptors() {
        List<PluginDescriptor> empty_collection = Collections.emptyList();
        return this.registeredPlugins.isEmpty() ? empty_collection : Collections.unmodifiableCollection(this.registeredPlugins.values());
    }

    @Override
    public Collection<PluginFragment> getPluginFragments() {
        List<PluginFragment> empty_collection = Collections.emptyList();
        return this.registeredFragments.isEmpty() ? empty_collection : Collections.unmodifiableCollection(this.registeredFragments.values());
    }

    @Override
    public Collection<PluginDescriptor> getDependingPlugins(PluginDescriptor descr) {
        HashMap<String, PluginDescriptor> result = new HashMap<String, PluginDescriptor>();
        block0: for (PluginDescriptor dependedDescr : this.getPluginDescriptors()) {
            if (dependedDescr.getId().equals(descr.getId())) continue;
            for (PluginPrerequisite pre : dependedDescr.getPrerequisites()) {
                if (!pre.getPluginId().equals(descr.getId()) || !pre.matches()) continue;
                if (result.containsKey(dependedDescr.getId())) continue block0;
                result.put(dependedDescr.getId(), dependedDescr);
                for (PluginDescriptor descriptor : this.getDependingPlugins(dependedDescr)) {
                    if (result.containsKey(descriptor.getId())) continue;
                    result.put(descriptor.getId(), descriptor);
                }
                continue block0;
            }
        }
        return result.values();
    }

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver) {
        return this.checkIntegrity(pathResolver, false);
    }

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver, boolean includeRegistrationReport) {
        List empty_collection = Collections.emptyList();
        IntegrityChecker intergityCheckReport = new IntegrityChecker(this, includeRegistrationReport ? this.registrationReport : empty_collection);
        intergityCheckReport.doCheck(pathResolver);
        return intergityCheckReport;
    }

    @Override
    public IntegrityCheckReport getRegistrationReport() {
        return new IntegrityChecker(this, this.registrationReport);
    }

    @Override
    public String makeUniqueId(String pluginId, String id) {
        return pluginId + '@' + id;
    }

    @Override
    public String makeUniqueId(String pluginId, Version version) {
        return pluginId + '@' + version;
    }

    @Override
    public String extractPluginId(String uniqueId) {
        int p = uniqueId.indexOf(64);
        if (p <= 0 || p >= uniqueId.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + uniqueId);
        }
        return uniqueId.substring(0, p);
    }

    @Override
    public String extractId(String uniqueId) {
        int p = uniqueId.indexOf(64);
        if (p <= 0 || p >= uniqueId.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + uniqueId);
        }
        return uniqueId.substring(p + 1);
    }

    @Override
    public Version extractVersion(String uniqueId) {
        int p = uniqueId.indexOf(64);
        if (p <= 0 || p >= uniqueId.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + uniqueId);
        }
        return Version.parse(uniqueId.substring(p + 1));
    }

    @Override
    public void registerListener(PluginRegistry.RegistryChangeListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("listener " + listener + " already registered");
        }
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(PluginRegistry.RegistryChangeListener listener) {
        if (!this.listeners.remove(listener)) {
            log.warn((Object)("unknown listener " + listener));
        }
    }

    void fireEvent(RegistryChangeDataImpl data) {
        data.dump();
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry.RegistryChangeListener[] arr = this.listeners.toArray(new PluginRegistry.RegistryChangeListener[this.listeners.size()]);
        data.beforeEventFire();
        if (log.isDebugEnabled()) {
            log.debug((Object)"propagating registry change event");
        }
        for (PluginRegistry.RegistryChangeListener element : arr) {
            element.registryChanged(data);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"registry change event propagated");
        }
        data.afterEventFire();
    }

    private static final class ManifestInfoImpl
    implements ManifestInfo {
        private final ModelManifestInfo model;

        ManifestInfoImpl(ModelManifestInfo aModel) {
            this.model = aModel;
        }

        public String getId() {
            return this.model.getId();
        }

        public Version getVersion() {
            return this.model.getVersion();
        }

        public String getVendor() {
            return this.model.getVendor();
        }

        public String getPluginId() {
            return this.model.getPluginId();
        }

        public Version getPluginVersion() {
            return this.model.getPluginVersion();
        }

        public MatchingRule getMatchingRule() {
            return this.model.getMatchRule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegistryChangeDataImpl
    implements PluginRegistry.RegistryChangeData {
        private Set<String> addedPlugins;
        private Set<String> removedPlugins;
        private Set<String> modifiedPlugins;
        private Map<String, String> addedExtensions;
        private Map<String, String> removedExtensions;
        private Map<String, String> modifiedExtensions;

        protected RegistryChangeDataImpl() {
            this.reset();
        }

        private void reset() {
            this.addedPlugins = new HashSet<String>();
            this.removedPlugins = new HashSet<String>();
            this.modifiedPlugins = new HashSet<String>();
            this.addedExtensions = new HashMap<String, String>();
            this.removedExtensions = new HashMap<String, String>();
            this.modifiedExtensions = new HashMap<String, String>();
        }

        protected void beforeEventFire() {
            this.addedPlugins = Collections.unmodifiableSet(this.addedPlugins);
            this.removedPlugins = Collections.unmodifiableSet(this.removedPlugins);
            this.modifiedPlugins = Collections.unmodifiableSet(this.modifiedPlugins);
            this.addedExtensions = Collections.unmodifiableMap(this.addedExtensions);
            this.removedExtensions = Collections.unmodifiableMap(this.removedExtensions);
            this.modifiedExtensions = Collections.unmodifiableMap(this.modifiedExtensions);
        }

        protected void afterEventFire() {
            this.reset();
        }

        protected void dump() {
            Log logger = LogFactory.getLog(this.getClass());
            if (!logger.isDebugEnabled()) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("PLUG-IN REGISTRY CHANGES DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tAdded plug-ins: " + this.addedPlugins.size() + "\r\n");
            for (String string : this.addedPlugins) {
                buf.append("\t\t").append((Object)string).append("\r\n");
            }
            buf.append("\tRemoved plug-ins: " + this.removedPlugins.size() + "\r\n");
            for (String string : this.removedPlugins) {
                buf.append("\t\t").append((Object)string).append("\r\n");
            }
            buf.append("\tModified plug-ins: " + this.modifiedPlugins.size() + "\r\n");
            for (String string : this.modifiedPlugins) {
                buf.append("\t\t").append((Object)string).append("\r\n");
            }
            buf.append("\tAdded extensions: " + this.addedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.addedExtensions.entrySet()) {
                buf.append("\t\t").append(entry).append("\r\n");
            }
            buf.append("\tRemoved extensions: " + this.removedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.removedExtensions.entrySet()) {
                buf.append("\t\t").append(entry).append("\r\n");
            }
            buf.append("\tModified extensions: " + this.modifiedExtensions.size() + "\r\n");
            for (Map.Entry entry : this.modifiedExtensions.entrySet()) {
                buf.append("\t\t").append(entry).append("\r\n");
            }
            buf.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
            buf.append("-------------- DUMP END -----------------\r\n");
            logger.debug((Object)buf.toString());
        }

        @Override
        public Set<String> addedPlugins() {
            return this.addedPlugins;
        }

        @Override
        public Set<String> removedPlugins() {
            return this.removedPlugins;
        }

        @Override
        public Set<String> modifiedPlugins() {
            return this.modifiedPlugins;
        }

        void putAddedExtension(String extensionUid, String extensionPointUid) {
            this.addedExtensions.put(extensionUid, extensionPointUid);
        }

        @Override
        public Set<String> addedExtensions() {
            return this.addedExtensions.keySet();
        }

        @Override
        public Set<String> addedExtensions(String extensionPointUid) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.addedExtensions.entrySet()) {
                if (!entry.getValue().equals(extensionPointUid)) continue;
                result.add(entry.getKey());
            }
            return Collections.unmodifiableSet(result);
        }

        void putRemovedExtension(String extensionUid, String extensionPointUid) {
            this.removedExtensions.put(extensionUid, extensionPointUid);
        }

        @Override
        public Set<String> removedExtensions() {
            return this.removedExtensions.keySet();
        }

        @Override
        public Set<String> removedExtensions(String extensionPointUid) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.removedExtensions.entrySet()) {
                if (!entry.getValue().equals(extensionPointUid)) continue;
                result.add(entry.getKey());
            }
            return Collections.unmodifiableSet(result);
        }

        void putModifiedExtension(String extensionUid, String extensionPointUid) {
            this.modifiedExtensions.put(extensionUid, extensionPointUid);
        }

        @Override
        public Set<String> modifiedExtensions() {
            return this.modifiedExtensions.keySet();
        }

        @Override
        public Set<String> modifiedExtensions(String extensionPointUid) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.modifiedExtensions.entrySet()) {
                if (!entry.getValue().equals(extensionPointUid)) continue;
                result.add(entry.getKey());
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

