/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.View;

public class FrameView
extends View {
    public static final String MAIN_FRAME_NAME = "mainFrame";
    private static final Logger logger = Logger.getLogger(FrameView.class.getName());
    private JFrame frame = null;

    public FrameView(Application application) {
        super(application);
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            ResourceMap resourceMap = this.getContext().getResourceMap();
            String title = resourceMap.getString("Application.title", new Object[0]);
            this.frame = new JFrame(title);
            this.frame.setName(MAIN_FRAME_NAME);
            if (resourceMap.containsKey("Application.icon")) {
                Image icon = resourceMap.getImageIcon("Application.icon").getImage();
                this.frame.setIconImage(icon);
            }
        }
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        if (this.frame != null) {
            throw new IllegalStateException("frame already set");
        }
        this.frame = frame;
        this.firePropertyChange("frame", null, this.frame);
    }

    @Override
    public JRootPane getRootPane() {
        return this.getFrame().getRootPane();
    }
}

