/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.binding.impl.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.namespace.QName;
import jlibs.core.lang.StringUtil;
import jlibs.core.lang.model.ModelUtil;
import jlibs.xml.sax.binding.Current;
import jlibs.xml.sax.binding.Parent;
import jlibs.xml.sax.binding.Relation;
import jlibs.xml.sax.binding.Temp;
import jlibs.xml.sax.binding.impl.processor.Binding;
import jlibs.xml.sax.binding.impl.processor.BindingAnnotation;
import jlibs.xml.sax.binding.impl.processor.BindingRelation;
import jlibs.xml.sax.binding.impl.processor.Relation;

class RelationAnnotation
extends BindingAnnotation {
    boolean start;

    RelationAnnotation(boolean start) {
        super(start ? Relation.Start.class : Relation.Finish.class, "public void " + (start ? "start" : "end") + "Relation(int state, SAXContext parent, SAXContext current) throws SAXException{");
        this.start = start;
    }

    @Override
    public void consume(Binding binding, ExecutableElement method, AnnotationMirror mirror) {
        super.consume(binding, method, mirror);
        for (AnnotationValue child : (Collection)ModelUtil.getAnnotationValue((Element)method, (AnnotationMirror)mirror, (String)"value")) {
            Binding parentBinding;
            String xpath = (String)child.getValue();
            int slash = xpath.lastIndexOf(47);
            if (slash == -1) {
                parentBinding = binding;
            } else {
                parentBinding = binding.getBinding(method, mirror, xpath.substring(0, slash));
                xpath = xpath.substring(slash + 1);
            }
            Relation childRelation = parentBinding.getRelation(method, mirror, xpath);
            if (this.start) {
                childRelation.startedMethod = method;
                continue;
            }
            childRelation.finishedMethod = method;
        }
    }

    @Override
    public String lvalue(ExecutableElement method) {
        TypeMirror mirror = method.getReturnType();
        switch (mirror.getKind()) {
            case VOID: {
                return "";
            }
        }
        String m = ModelUtil.getAnnotationMirror((Element)method, Temp.Add.class) == null ? "put" : "add";
        return "parent." + m + "(current.element(), ";
    }

    @Override
    public String params(ExecutableElement method) {
        boolean parent = method.getReturnType().getKind() == TypeKind.VOID;
        ArrayList<String> params = new ArrayList<String>();
        for (VariableElement variableElement : method.getParameters()) {
            AnnotationMirror mirror = ModelUtil.getAnnotationMirror((Element)variableElement, Temp.class);
            if (mirror == null) {
                if (ModelUtil.getAnnotationMirror((Element)variableElement, Parent.class) != null) {
                    parent = true;
                } else if (ModelUtil.getAnnotationMirror((Element)variableElement, Current.class) != null) {
                    parent = false;
                }
                params.add(this.context(variableElement, parent));
                parent = !parent;
                continue;
            }
            String value = (String)ModelUtil.getAnnotationValue((Element)variableElement, (AnnotationMirror)mirror, (String)"value");
            if (value.length() == 0) {
                value = variableElement.getSimpleName().toString();
            }
            QName qname = Binding.toQName(variableElement, mirror, value);
            StringBuilder buff = new StringBuilder();
            buff.append("(").append(ModelUtil.toString((TypeMirror)variableElement.asType(), (boolean)true)).append(")");
            buff.append("current.get(");
            buff.append('\"').append(qname.getNamespaceURI()).append("\", ");
            buff.append('\"').append(qname.getLocalPart()).append('\"');
            buff.append(")");
            params.add(buff.toString());
        }
        return StringUtil.join(params.iterator());
    }

    @Override
    boolean getMethods(Binding binding, List<ExecutableElement> methods) {
        methods.add(null);
        return this._getMethods(binding, methods);
    }

    private boolean _getMethods(Binding binding, List<ExecutableElement> methods) {
        boolean nonEmpty = false;
        for (BindingRelation bindingRelation : binding.registry.values()) {
            ExecutableElement method = this.start ? bindingRelation.relation.startedMethod : bindingRelation.relation.finishedMethod;
            nonEmpty |= method != null;
            methods.add(method);
            nonEmpty |= this._getMethods(bindingRelation.binding, methods);
        }
        return nonEmpty;
    }
}

