/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.dom;

import javax.xml.namespace.NamespaceContext;
import jlibs.core.graph.Convertor;
import jlibs.core.lang.StringUtil;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class DOMXPathNameConvertor
implements Convertor<Node, String> {
    private NamespaceContext nsContext;

    public DOMXPathNameConvertor(NamespaceContext nsContext) {
        this.nsContext = nsContext;
    }

    public DOMXPathNameConvertor() {
    }

    public String convert(Node source) {
        switch (source.getNodeType()) {
            case 9: {
                return "";
            }
            case 3: 
            case 4: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)source;
                return "processing-instruction('" + pi.getTarget() + "')";
            }
            case 1: {
                if (this.nsContext != null) {
                    String prefix = this.nsContext.getPrefix(source.getNamespaceURI());
                    String name = source.getLocalName();
                    return StringUtil.isEmpty((CharSequence)prefix) ? name : prefix + ':' + name;
                }
                return source.getNodeName();
            }
            case 2: {
                if ("http://www.w3.org/2000/xmlns/".equals(source.getNamespaceURI())) {
                    return "namespace::" + source.getLocalName();
                }
                if (this.nsContext != null) {
                    String prefix = this.nsContext.getPrefix(source.getNamespaceURI());
                    String name = source.getLocalName();
                    return '@' + (StringUtil.isEmpty((CharSequence)prefix) ? name : prefix + ':' + name);
                }
                return '@' + source.getNodeName();
            }
            case 13: {
                return "namespace::" + source.getLocalName();
            }
        }
        return null;
    }
}

