/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.tree;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtilities {
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    private static final Logger LOG = Logger.getLogger(TreeUtilities.class.getName());

    public static Enumeration children(TreeModel model) {
        return TreeUtilities.children(model, model.getRoot());
    }

    public static Enumeration children(final TreeModel model, final Object parent) {
        if (parent == null || model.isLeaf(parent)) {
            return EMPTY_ENUMERATION;
        }
        Enumeration e = new Enumeration(){
            int currentIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return model.getChildCount(parent) > this.currentIndex;
            }

            public Object nextElement() {
                return model.getChild(parent, this.currentIndex++);
            }
        };
        return e;
    }

    private TreeUtilities() {
    }

    public static class BreadthFirstNodeEnumeration<M extends TreeNode>
    implements Enumeration<M> {
        protected Queue<Enumeration<M>> queue;

        public BreadthFirstNodeEnumeration(M rootNode) {
            Vector<M> v = new Vector<M>(1);
            v.addElement(rootNode);
            this.queue = new ArrayDeque<Enumeration<M>>();
            this.queue.offer(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && this.queue.peek().hasMoreElements();
        }

        @Override
        public M nextElement() {
            Enumeration<M> enumer = this.queue.peek();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration<? extends TreeNode> children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.poll();
            }
            if (children.hasMoreElements()) {
                this.queue.offer(children);
            }
            return (M)node;
        }
    }

    public static class PostorderNodeEnumeration<M extends TreeNode>
    implements Enumeration<M> {
        protected M root;
        protected Enumeration<M> children;
        protected Enumeration<M> subtree;

        public PostorderNodeEnumeration(M rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public M nextElement() {
            TreeNode retval;
            if (this.subtree.hasMoreElements()) {
                retval = (TreeNode)this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderNodeEnumeration<TreeNode>((TreeNode)this.children.nextElement());
                retval = (TreeNode)this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return (M)retval;
        }
    }

    public static class PreorderNodeEnumeration<M extends TreeNode>
    implements Enumeration<M> {
        protected Deque<Enumeration<M>> stack;

        public PreorderNodeEnumeration(M rootNode) {
            Vector<M> v = new Vector<M>(1);
            v.addElement(rootNode);
            this.stack = new ArrayDeque<Enumeration<M>>();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.isEmpty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public M nextElement() {
            Enumeration<M> enumer = this.stack.peek();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration<? extends TreeNode> children = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return (M)node;
        }
    }

    public static class PostorderModelEnumeration
    implements Enumeration {
        protected TreeModel model;
        protected Object root;
        protected Enumeration children;
        protected Enumeration subtree;

        public PostorderModelEnumeration(TreeModel model) {
            this(model, model.getRoot());
        }

        public PostorderModelEnumeration(TreeModel model, Object node) {
            this.model = model;
            this.root = node;
            this.children = TreeUtilities.children(model, this.root);
            this.subtree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        public Object nextElement() {
            Object retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderModelEnumeration(this.model, this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    public static class BreadthFirstModelEnumeration
    implements Enumeration {
        protected Queue<Enumeration> queue;
        private TreeModel model;

        public BreadthFirstModelEnumeration(TreeModel model) {
            this(model, model.getRoot());
        }

        public BreadthFirstModelEnumeration(TreeModel model, Object node) {
            this.model = model;
            Vector<Object> v = new Vector<Object>(1);
            v.addElement(node);
            this.queue = new ArrayDeque<Enumeration>();
            this.queue.offer(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && this.queue.peek().hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = this.queue.peek();
            Object node = enumer.nextElement();
            Enumeration children = TreeUtilities.children(this.model, node);
            if (!enumer.hasMoreElements()) {
                this.queue.poll();
            }
            if (children.hasMoreElements()) {
                this.queue.offer(children);
            }
            return node;
        }
    }

    public static class PreorderModelEnumeration
    implements Enumeration {
        protected Deque<Enumeration> stack;
        protected TreeModel model;
        private TreePath path;

        public PreorderModelEnumeration(TreeModel model) {
            this(model, model.getRoot());
        }

        public PreorderModelEnumeration(TreeModel model, Object node) {
            this.model = model;
            this.stack = new ArrayDeque<Enumeration>();
            this.pushNodeAsEnumeration(node);
        }

        public PreorderModelEnumeration(TreeModel model, TreePath path) {
            this(model, path.getLastPathComponent());
            this.path = path;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.isEmpty() && this.stack.peek().hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = this.stack.peek();
            Object node = enumer.nextElement();
            Enumeration children = TreeUtilities.children(this.model, node);
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            if (!this.hasMoreElements()) {
                this.updateSubtree();
            }
            return node;
        }

        private void updateSubtree() {
            Object currentNode;
            if (this.path == null) {
                return;
            }
            TreePath parentPath = this.path.getParentPath();
            if (parentPath == null) {
                this.path = null;
                return;
            }
            Object parent = parentPath.getLastPathComponent();
            int currentIndex = this.model.getIndexOfChild(parent, currentNode = this.path.getLastPathComponent());
            if (currentIndex + 1 < this.model.getChildCount(parent)) {
                Object child = this.model.getChild(parent, currentIndex + 1);
                this.path = parentPath.pathByAddingChild(child);
                this.pushNodeAsEnumeration(child);
            } else {
                this.path = parentPath;
                this.updateSubtree();
            }
        }

        private void pushNodeAsEnumeration(Object node) {
            Vector<Object> v = new Vector<Object>(1);
            v.add(node);
            this.stack.push(v.elements());
        }
    }
}

